# StateMachine 2.3.0

*June 7, 2024*

## What's new in 2.3.0

This release has a high expected feature, we're adding [asynchronous support](../async.md), and enhancing overall functionality. In fact, the approach we took was to go all the way down changing the internals of the library to be fully async, keeping only the current external API as a thin sync/async adapter.


### Python compatibility 2.3.0

StateMachine 2.3.0 supports Python 3.7, 3.8, 3.9, 3.10, 3.11 and 3.12.

We've fixed a bug on the package declaration that was preventing users from Python 3.7 to install the latest version.

### Asynchronous Support in 2.3.0

This release introduces native coroutine support using asyncio, enabling seamless integration with asynchronous code.

Now you can send and await for events, and also write async {ref}`Actions`, {ref}`Conditions` and {ref}`Validators`.


```{seealso}
See {ref}`sphx_glr_auto_examples_air_conditioner_machine.py` for an example of
async code with a state machine.
```


```py
>>> class AsyncStateMachine(StateMachine):
...     initial = State('Initial', initial=True)
...     final = State('Final', final=True)
...
...     advance = initial.to(final)
...
...     async def on_advance(self):
...         return 42



>>> async def run_sm():
...     sm = AsyncStateMachine()
...     res = await sm.advance()
...     return (42, sm.current_state.name)

>>> asyncio.run(run_sm())
(42, 'Final')

```
