#!/usr/bin/env python

'''The setup and build script for the python-statusio library.'''

import os

from setuptools import setup, find_packages

def read(*paths):
    """Build a file path from *paths* and return the contents."""
    with open(os.path.join(*paths), 'r') as f:
        return f.read()


setup(
    name='python-statusio',
    version='0.2',
    author='Status.io',
    author_email='support@status.io',
    license='Apache License 2.0',
    url='https://github.com/statusio/python-statusio',
    keywords='status.io api statusio',
    description='A Python wrapper around the Status.io API',
    long_description=(read('README.rst')),
    packages=find_packages(exclude=['tests*']),
    install_requires=['future', 'requests'],
    classifiers=[
        'Development Status :: 5 - Production/Stable',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: Apache Software License',
        'Operating System :: OS Independent',
        'Topic :: Software Development :: Libraries :: Python Modules',
        'Topic :: Internet',
        'Programming Language :: Python',
        'Programming Language :: Python :: 2',
        'Programming Language :: Python :: 2.7',
    ],
)
