from enum import IntEnum


class PublishedFileQueryType(IntEnum):
    RANKED_BY_VOTE = 0
    RANKED_BY_PUBLICATION_DATE = 1
    ACCEPTED_FOR_GAME_RANKED_BY_ACCEPTANCE_DATE = 2
    RANKED_BY_TREND = 3
    FAVORITED_BY_FRIENDS_RANKED_BY_PUBLICATION_DATE = 4
    CREATED_BY_FRIENDS_RANKED_BY_PUBLICATION_DATE = 5
    RANKED_BY_NUM_TIMES_REPORTED = 6
    CREATED_BY_FOLLOWED_USERS_RANKED_BY_PUBLICATION_DATE = 7
    NOT_YET_RATED = 8
    RANKED_BY_TOTAL_UNIQUE_SUBSCRIPTIONS = 9
    RANKED_BY_TOTAL_VOTES_ASC = 10
    RANKED_BY_VOTES_UP = 11
    RANKED_BY_TEXT_SEARCH = 12
    RANKED_BY_PLAYTIME_TREND = 13
    RANKED_BY_TOTAL_PLAYTIME = 14
    RANKED_BY_AVERAGE_PLAYTIME_TREND = 15
    RANKED_BY_LIFETIME_AVERAGE_PLAYTIME = 16
    RANKED_BY_PLAYTIME_SESSIONS_TREND = 17
    RANKED_BY_LIFETIME_PLAYTIME_SESSIONS = 18
    RANKED_BY_INAPPROPRIATE_CONTENT_RATING = 19
    RANKED_BY_BAN_CONTENT_CHECK = 20
    RANKED_BY_LAST_UPDATED_DATE = 21


class PublishedFileInfoMatchingFileType(IntEnum):
    ITEMS = 0
    COLLECTIONS = 1
    ART = 2
    VIDEOS = 3
    SCREENSHOTS = 4
    COLLECTION_ELIGIBLE = 5
    GAMES = 6
    SOFTWARE = 7
    CONCEPTS = 8
    GREENLIGHT_ITEMS = 9
    ALL_GUIDES = 10
    WEB_GUIDES = 11
    INTEGRATED_GUIDES = 12
    USABLE_IN_GAME = 13
    MERCH = 14
    CONTROLLER_BINDINGS = 15
    STEAMWORKS_ACCESS_INVITES = 16
    ITEMS_MTX = 17
    ITEMS_READY_TO_USE = 18
    WORKSHOP_SHOWCASE = 19
    GAME_MANAGED_ITEMS = 20
