# Python String Utils

A small utility library to check and manipulate strings.

- simple and pythonic
- fast (based on compiled regex)
- no external dependencies
- fully documented
- PEP8 complaint
- 100% code coverage
- tested against multiple python versions (2.7, 3.2, 3.3, 3.4, 3.5)


## What's inside...

### String checking functions:

- is_string
- is_full_string
- is_ip
- is_url
- is_email
- is_credit_card
- is_camel_case
- is_snake_case
- is_json
- is_uuid
- is_pangram
- is_palindrome
- is_isogram
- words_count
- contains_html

### String manipulation and generation

- camel_case_to_snake
- snake_case_to_camel
- reverse
- uuid
- shuffle
- strip_html
- prettify


...and more are coming!


## Installation

    pip install python-string-utils


## Documentation

Full API documentation available on: <http://python-string-utils.readthedocs.org/en/latest/>
