from setuptools import setup, find_packages

with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

setup(
    name="python-structures",
    version="0.1.0",
    author="Piotr Żarczyński",
    description="A small package for creating and manipulating structs similar to those in C/C++",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/tpxHorus/python-structures",
    project_urls={
        "Bug Tracker": "https://github.com/tpxHorus/python-structures/issues",
    },
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
    package_dir={"": "src"},
    packages=find_packages(where="src"),
    python_requires=">=3.10",
)