import os
from setuptools import find_packages, setup

from python_telegram_logger import __version__, __author__


with open(os.path.join(os.path.dirname(__file__), 'README.rst')) as readme:
    README = readme.read()

# allow setup.py to be run from any path
os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))

setup(
    name='python-telegram-logger',
    version=__version__,
    packages=find_packages(),
    include_package_data=True,
    license='BSD License',
    description='Simple telegram logger',
    long_description=README,
    url='https://github.com/porovozls/python-telegram-logger',
    author=__author__,
    author_email='porovozls@gmail.com',
    classifiers=[
        'Intended Audience :: Developers',
        'License :: OSI Approved :: BSD License',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Programming Language :: Python :: 3.5',
        'Programming Language :: Python :: 3.6',
        'Topic :: Internet :: WWW/HTTP',
        'Topic :: Internet :: WWW/HTTP :: Dynamic Content',
    ],
    install_requires=[
        'requests'
    ]
)
