#!/usr/bin/env python3
"""
An autogenerated testfile for python.
"""

import os
import sys
import unittest
from io import StringIO
from unittest import TextTestRunner
from unittest.mock import patch

from tester import ExamTestCase, ExamTestResult, find_path_to_assignment, tags, setup_and_get_repo_path

FILE_DIR = os.path.dirname(os.path.realpath(__file__))
REPO_PATH = setup_and_get_repo_path(FILE_DIR)

class Test1ConvertStructure(ExamTestCase):
    """
    Each assignment has 1 testcase with multiple asserts.
    The different asserts https://docs.python.org/3.6/library/unittest.html#test-cases
    """

    @tags("struct")
    def test_file_convert_py_exist(self):
        """
        Testerna hittar inte filen 'convert.py'.
        """
        with patch("builtins.input", side_effect=""):
            with patch("sys.stdout", new=StringIO()) as _:
                try:
                    self.assertModule("convert", REPO_PATH)
                except StopIteration:
                    self.assertTrue(True)


if __name__ == "__main__":
    runner = TextTestRunner(resultclass=ExamTestResult, verbosity=2)
    unittest.main(testRunner=runner, exit=False)
