import requests
from timekit.components.base import *
__all__ = ["Booking"]


class Group(APIBaseMethod):
    def __init__(self, app_token):
        APIBaseMethod.__init__(self, app_token)
        self.url = "{}/bookings/groups".format(self.url)

    # def list(self, limit=50, page=1, search="") -> Response:
    #     """
    #     limit: integer (1000 max),
    #     page: integer,
    #     search: string,
    #     for more information refer https://developers.timekit.io/reference#bookings-2
    #     """
    #     request_url = "{}?limit={}&page={}&search={}".format(
    #         self.url, limit, page, search)
    #     response = requests.get(request_url,
    #                             auth=self.auth,
    #                             headers=self.headers)
    #     return handle_response(response)

    # def retrieve(self, id) -> Response:
    #     """
    #     id: string(id generated by timekit)
    #     for more information refer https://developers.timekit.io/reference#bookings-2
    #     """
    #     request_url = "{}/{}".format(self.url, id)
    #     response = requests.get(request_url,
    #                             auth=self.auth,
    #                             headers=self.headers)
    #     return handle_response(response)


class Booking(APIBaseMethod):
    def __init__(self, app_token):
        APIBaseMethod.__init__(self, app_token)
        self.url = "{}/bookings".format(self.url)
        self.groups = Group(app_token)

    def create(self, data, dynamic_includes=[]) -> Response:
        """
        data: json object, 
        dynamic_includes: list
        for more information refer https://developers.timekit.io/reference#bookings
        """
        includes = ""
        if dynamic_includes != [] and type(dynamic_includes) is list:
            includes = ",".join(dynamic_includes)
        request_url = "{}?include={}".format(self.url, includes)
        response = requests.post(request_url,
                                 json=data,
                                 headers=self.headers,
                                 auth=self.auth)
        return handle_response(response)

    def list(self,
             limit=50,
             page=1,
             dynamic_includes=[],
             search="",
             order_by=None,
             sorted_by=None) -> Response:
        """
        limit: integer (1000 max), 
        page: integer,
        dynamic_includes: list, 
        search: string, 
        order_by: string, 
        sorted_by: string
        for more information refer https://developers.timekit.io/reference#bookings-2
        """
        includes = ""
        if dynamic_includes != [] and type(dynamic_includes) is list:
            includes = ",".join(dynamic_includes)
        request_url = "{}?limit={}&page={}include={}".format(
            self.url, limit, page, includes)
        if search:
            request_url = '{}&search={}'.format(request_url, search)
        if order_by:
            request_url = '{}&orderBy={}'.format(request_url, order_by)
        if sorted_by:
            request_url = '{}&sortedBy={}'.format(request_url, sorted_by)
        response = requests.get(request_url,
                                json=None,
                                headers=self.headers,
                                auth=self.auth)
        return handle_response(response)

    def update_state(self, id, action) -> Response:
        """
        id: string(id generated by timekit)
        action: string(confirm|decline|cancel|cancel_by_owner)
        for more information refer https://developers.timekit.io/reference#bookingsidaction
        """
        if action and action not in [
                'confirm', 'decline', 'cancel', 'cancel_by_owner'
        ]:
            raise Exception("function argument action is invalid!")
        response = requests.put("{}/{}/{}".format(self.url, id, action),
                                auth=self.auth,
                                headers=self.headers)
        return handle_response(response)

    def update_meta(self, id, data) -> Response:
        """
        id: string(id generated by timekit)
        data: json object
        for more information refer https://developers.timekit.io/reference#update-booking-meta-data
        """
        response = requests.put("{}/{}".format(self.url, id),
                                json=data,
                                auth=self.auth,
                                headers=self.headers)
        return handle_response(response)

    def create_in_bulk(self, data) -> Response:
        """
        data: json object containing multiple booking details
        for more information refer https://developers.timekit.io/reference#bookingsbulk
        """
        response = requests.post("{}".format(self.url),
                                 json=data,
                                 auth=self.auth,
                                 headers=self.headers)
        return handle_response(response)

    def update_in_bulk(self, data) -> Response:
        """
        data: json object containing multiple booking details
        for more information refer https://developers.timekit.io/reference#bookingsbulk-1
        """
        response = requests.put("{}".format(self.url),
                                json=data,
                                auth=self.auth,
                                headers=self.headers)
        return handle_response(response)