from collections.abc import Collection, Iterator
from typing import Protocol, TypeVar

T_XmlBackend = TypeVar("T_XmlBackend")


class XMLBackend[T_XmlBackend](Protocol):
  def get_tag(self, element: T_XmlBackend) -> str: ...
  def make_elem(self, tag: str) -> T_XmlBackend: ...
  def append(self, parent: T_XmlBackend, child: T_XmlBackend) -> None: ...
  def get_attr(self, element: T_XmlBackend, key: str) -> str | None: ...
  def set_attr(self, element: T_XmlBackend, key: str, val: str) -> None: ...
  def get_text(self, element: T_XmlBackend) -> str | None: ...
  def set_text(self, element: T_XmlBackend, text: str | None) -> None: ...
  def get_tail(self, element: T_XmlBackend) -> str | None: ...
  def set_tail(self, element: T_XmlBackend, tail: str | None) -> None: ...
  def iter_children(
    self, element: T_XmlBackend, tag: str | Collection[str] | None = None
  ) -> Iterator[T_XmlBackend]: ...
