#!/usr/bin/env python

import codecs
import os
import re

try:
    from setuptools import setup
except ImportError:
    from distutils.core import setup

here = os.path.abspath(os.path.dirname(__file__))

# Read the version number from a source file.
# Why read it, and not import?
# see https://groups.google.com/d/topic/pypa-dev/0PkjVpcxTzQ/discussion
def find_version(*file_paths):
    # Open in Latin-1 so that we avoid encoding errors.
    # Use codecs.open for Python 2 compatibility
    with codecs.open(os.path.join(here, *file_paths), 'r', 'latin1') as f:
        version_file = f.read()

    # The version line must have the form
    # __version__ = 'ver'
    version_match = re.search(r"^__version__ = ['\"]([^'\"]*)['\"]",
                              version_file, re.M)
    if version_match:
        return version_match.group(1)
    raise RuntimeError("Unable to find version string.")

with codecs.open('README.rst', encoding='utf-8') as f:
    readme = f.read()

with codecs.open('HISTORY.rst', encoding='utf-8') as f:
    history = f.read()

setup(
    name="python-traceview",
    version=find_version('traceview', '__init__.py'),
    description="TraceView API Client",
    long_description=readme + '\n\n' + history,

    # The project URL.
    url='https://github.com/danriti/python-traceview',

    # Author details
    author='Daniel Riti',
    author_email='dmriti@gmail.com',

    # Choose your license
    license='MIT',

    classifiers=[
        # How mature is this project? Common values are
        #   3 - Alpha
        #   4 - Beta
        #   5 - Production/Stable
        'Development Status :: 4 - Beta',

        # Indicate who your project is intended for
        'Intended Audience :: Developers',

        # Pick your license as you wish (should match "license" above)
        'License :: OSI Approved :: MIT License',

        # Specify the Python versions you support here. In particular, ensure
        # that you indicate whether you support Python 2, Python 3 or both.
        'Programming Language :: Python :: 2',
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.2',
        'Programming Language :: Python :: 3.3',
        'Programming Language :: Python :: 3.4',
    ],

    keywords='traceview api client development performance',

    packages=[
        'traceview'
    ],

    install_requires=[
        'requests == 2.2.1'
    ],

    package_data={'': ['README.rst']},
    package_dir={'traceview': 'traceview'},
    include_package_data=True,
)
