import abc
from typing import Any, List, Tuple, Union

from troveclient.client import HTTPClient, SessionClient
from troveclient.shell import TroveClientArgumentParser

def load_auth_system_opts(parser: TroveClientArgumentParser): ...
def load_plugin(auth_system: str) -> Any: ...

class BaseAuthPlugin(metaclass=abc.ABCMeta):
    def __init__(self, auth_system: Any = None, **kwargs): ...
    @staticmethod
    def _parser_add_opt(parser: TroveClientArgumentParser, opt: str): ...
    @classmethod
    def add_opts(cls, parser: TroveClientArgumentParser): ...
    @classmethod
    def add_common_opts(cls, parser: TroveClientArgumentParser): ...
    @staticmethod
    def get_opt(opt_name: str, args: Any) -> Tuple[str, Any]: ...
    def parse_opts(self, args: Any) -> None: ...
    def authenticate(self, http_client: Union[HTTPClient, SessionClient]) -> None: ...
    @abc.abstractmethod
    def _do_authenticate(self, http_client: Union[HTTPClient, SessionClient]): ...
    def sufficient_options(self) -> None: ...
    @abc.abstractmethod
    def token_and_endpoint(
        self, endpoint_type: str, service_type: str
    ) -> Tuple[str, List[str]]: ...
