# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
# implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from testtools import TestCase

import troveclient.v1.client
from troveclient.client import get_version_map
from troveclient.openstack.common.apiclient import client
from troveclient.openstack.common.apiclient import exceptions


class ClientTest(TestCase):

    def test_get_client_class_v1(self):
        version_map = get_version_map()
        output = client.BaseClient.get_class('database',
                                             '1.0', version_map)
        self.assertEqual(output, troveclient.v1.client.Client)

    def test_get_client_class_unknown(self):
        version_map = get_version_map()
        self.assertRaises(exceptions.UnsupportedVersion,
                          client.BaseClient.get_class, 'database',
                          '0', version_map)
