#
# Copyright 2012 Patrick Hetu <patrick.hetu@gmail.com>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from jsonschema import validate, ValidationError

COUNTRY_CODES = [
    "AD",
    "AE",
    "AF",
    "AG",
    "AI",
    "AL",
    "AM",
    "AN",
    "AO",
    "AQ",
    "AR",
    "AS",
    "AT",
    "AU",
    "AW",
    "AX",
    "AZ",
    "BA",
    "BB",
    "BD",
    "BE",
    "BF",
    "BG",
    "BH",
    "BI",
    "BJ",
    "BL",
    "BM",
    "BN",
    "BO",
    "BR",
    "BS",
    "BT",
    "BV",
    "BW",
    "BY",
    "BZ",
    "CA",
    "CC",
    "CD",
    "CF",
    "CG",
    "CH",
    "CI",
    "CK",
    "CL",
    "CM",
    "CN",
    "CO",
    "CR",
    "CU",
    "CV",
    "CX",
    "CY",
    "CZ",
    "DE",
    "DJ",
    "DK",
    "DM",
    "DO",
    "DZ",
    "EC",
    "EE",
    "EG",
    "EH",
    "ER",
    "ES",
    "ET",
    "FI",
    "FJ",
    "FK",
    "FM",
    "FO",
    "FR",
    "GA",
    "GB",
    "GD",
    "GE",
    "GF",
    "GH",
    "GI",
    "GL",
    "GM",
    "GN",
    "GP",
    "GQ",
    "GR",
    "GS",
    "GT",
    "GU",
    "GW",
    "GY",
    "HK",
    "HM",
    "HN",
    "HR",
    "HT",
    "HU",
    "ID",
    "IE",
    "IL",
    "IM",
    "IN",
    "IO",
    "IQ",
    "IR",
    "IS",
    "IT",
    "JE",
    "JM",
    "JO",
    "JP",
    "KE",
    "KG",
    "KH",
    "KI",
    "KM",
    "KN",
    "KP",
    "KR",
    "KW",
    "KY",
    "KZ",
    "LB",
    "LC",
    "LI",
    "LK",
    "LR",
    "LS",
    "LT",
    "LU",
    "LV",
    "LY",
    "MA",
    "MC",
    "MD",
    "ME",
    "MF",
    "MG",
    "MH",
    "MK",
    "ML",
    "MM",
    "MN",
    "MO",
    "MP",
    "MQ",
    "MR",
    "MS",
    "MT",
    "MU",
    "MV",
    "MW",
    "MX",
    "MY",
    "MZ",
    "NA",
    "NC",
    "NE",
    "NF",
    "NG",
    "NI",
    "NL",
    "NO",
    "NP",
    "NR",
    "NU",
    "NZ",
    "OM",
    "PA",
    "PE",
    "PF",
    "PG",
    "PH",
    "PK",
    "PL",
    "PM",
    "PN",
    "PR",
    "PS",
    "PT",
    "PW",
    "PY",
    "QA",
    "RE",
    "RO",
    "RU",
    "RS",
    "RW",
    "SA",
    "SB",
    "SC",
    "SD",
    "SE",
    "SG",
    "SH",
    "SI",
    "SJ",
    "SK",
    "SL",
    "SM",
    "SN",
    "SO",
    "SR",
    "ST",
    "SV",
    "SY",
    "SZ",
    "TC",
    "TD",
    "TF",
    "TG",
    "TH",
    "TJ",
    "TK",
    "TM",
    "TN",
    "TO",
    "TL",
    "TR",
    "TT",
    "TV",
    "TW",
    "TZ",
    "UA",
    "UG",
    "UM",
    "US",
    "UY",
    "UZ",
    "VA",
    "VC",
    "VE",
    "VG",
    "VI",
    "VN",
    "VU",
    "WF",
    "WS",
    "YE",
    "YT",
    "YU",
    "ZA",
    "ZM",
    "ZW",
    "GG",
]

PRODUCTS = {
    'freessl30' : {
        'name' : 'FreeSSL 30 Day Trial',
        'periods' : [ 1 ],
        'vetting' : 'DOM',
        'process' : '1',
        'reissuance' : 0,
        'canrenew' : 0
    },
    'rapidssl' : {
        'name' : 'RapidSSL',
        'periods' : [ 12, 24, 36, 48, 60 ],
        'vetting' : 'DOM',
        'process' : '1',
        'reissuance' : 1,
        'canrenew' : 1,
    },
    'rapidsslwildcard' : {
        'name' : 'RapidSSL Wildcard',
        'periods' : [ 12, 24, 36, 48, 60 ],
        'vetting' : 'DOM',
        'process' : '1',
        'reissuance' : 1,
        'canrenew' : 1,
    },
    'geotrust30' : {
        'name' : 'GeoTrust SSL 30 Day Trial',
        'periods' : [ 1 ],
        'vetting' : 'DOM',
        'process' : '1',
        'reissuance' : 0,
        'canrenew' : 0
    },
    'quickssl' : {
        'name' : 'QuickSSL Basic',
        'periods' : [ 12, 24, 36, 48, 60 ],
        'vetting' : 'DOM',
        'process' : '1',
        'reissuance' : 0,
        'canrenew' : 1
    },
    'quicksslpremium' : {
        'name' : 'QuickSSL Premium',
        'periods' : [ 12, 24, 36, 48, 60, 72 ],
        'vetting' : 'DOM',
        'process' : '1',
        'reissuance' : 0,
        'canrenew' : 1
    },
    'truebusinessid' : {
        'name' : 'True BusinessID',
        'periods' : [ 12, 24, 36, 48, 60 ],
        'vetting' : 'ORG',
        'process' : '2',
        'reissuance' : 0,
        'canrenew' : 1
    },
    'truebusinessidwild' : {
        'name' : 'True BusinessID Wildcard',
        'periods' : [ 12, 24, 36, 48, 60 ],
        'vetting' : 'ORG',
        'process' : '2',
        'reissuance' : 0,
        'canrenew' : 1
    },
    'truebusinessidev' : {
        'name' : 'True BusinessID Wildcard',
        'periods' : [ 12, 24 ],
        'vetting' : 'ORG',
        'process' : '2',
        'reissuance' : 0,
        'canrenew' : 1
    },
    'power' : {
        'name' : 'Power Server ID',
        'periods' : [ 12, 24, 36, 48, 60, 72 ],
        'vetting' : 'ORG',
        'process' : '2',
        'reissuance' : 0,
        'canrenew' : 1
    },
    'powerwild' : {
        'name' : 'Power Server ID Wildcard',
        'periods' : [ 12, 24, 36, 48, 60, 72 ],
        'vetting' : 'ORG',
        'process' : '2',
        'reissuance' : 0,
        'canrenew' : 1
    },
    'secure' : {
        'name' : 'Secure Site',
        'periods' : [ 12, 24, 36 ],
        'vetting' : 'ORG',
        'process' : '2',
        'reissuance' : 0,
        'canrenew' : 1
    },
    'securepro' : {
        'name' : 'Secure Site Pro',
        'periods' : [ 12, 24, 36 ],
        'vetting' : 'ORG',
        'process' : '2',
        'reissuance' : 0,
        'canrenew' : 1
    },
    'secureev' : {
        'name' : 'Secure Site + EV',
        'periods' : [ 12, 24 ],
        'vetting' : 'ORG',
        'process' : '2',
        'reissuance' : 0,
        'canrenew' : 1
    },
    'secureproev' : {
        'name' : 'Secure Site Pro + EV',
        'periods' : [ 12, 24 ],
        'vetting' : 'ORG',
        'process' : '2',
        'reissuance' : 0,
        'canrenew' : 1
    },
    'ssl123' : {
        'name' : 'SSL123',
        'periods' : [ 12, 24, 36, 48, 60 ],
        'vetting' : 'ORG',
        'process' : '2',
        'reissuance' : 0,
        'canrenew' : 1
    }
}

PROCESS = {
    '1' : {
        'admin' : {
            'title' : 'AdminTitle',
            'firstname' : 'AdminFirstName',
            'lastname' : 'AdminLastName',
            'organisation' : 'AdminOrganization',
            'taxid' : 'AdminTaxID',
            'role' : 'AdminRole',
        
            'email' : 'AdminEmail',
            'phonecc' : 'AdminPhoneCC',
            'phoneac' : 'AdminPhoneAC',
            'phonen' : 'AdminPhoneN',
            'address1' : 'AdminAddress1',
            'address2' : 'AdminAddress2',
            'city' : 'AdminCity',
            'state' : 'AdminState',
            'postcode' : 'AdminPostCode',
            'country' : 'AdminCountry',
            'day' : 'AdminMemDateD',
            'month' : 'AdminMemDateM',
            'year' : 'AdminMemDateY'
        },
        'tech' : {
            'title' : 'TechTitle',
            'firstname' : 'TechFirstName',
            'lastname' : 'TechLastName',
            'organisation' : 'TechOrganization',
            'email' : 'TechEmail',
            'phonecc' : 'TechPhoneCC',
            'phoneac' : 'TechPhoneAC',
            'phonen' : 'TechPhoneN',
            'address1' : 'TechAddress1',
            'address2' : 'TechAddress2',
            'city' : 'TechCity',
            'state' : 'TechState',
            'postcode' : 'TechPostCode',
            'country' : 'TechCountry'
        },
        'techusereseller' : 'TechUseReseller',
        'product' : 'ProductName',
        'csr' : 'CSR',
        'domain' : 'Domain',
        'period' : 'ValidityPeriod',
        'insurance' : 'Insurance',
        'servercount' : 'ServerCount',
        'approver' : 'ApproverEmail',
        'dnsnames' : 'DnsNames',
        'special' : 'SpecialInstructions',
        'terms' : 'AgreedToTerms',
        'novalidation' : 'NoCSRValidation'
    },
    '2' : {
        'org' : {
            'name' : 'OrgName',
            'duns' : 'OrgDUNS',
            'taxid' : 'OrgTaxID',
            'address1' : 'OrgAddress1',
            'address2' : 'OrgAddress2',
            'city' : 'OrgCity',
            'state' : 'OrgState',

            'postcode' : 'OrgPostCode',
            'country' : 'OrgCountry',
            'phonecc' : 'OrgPhoneCC',
            'phoneac' : 'OrgPhoneAC',
            'phonen' : 'OrgPhoneN'
        },
        'admin' : {
            'title' : 'AdminTitle',
            'firstname' : 'AdminFirstName',
            'lastname' : 'AdminLastName',
            'role' : 'AdminRole',
            'email' : 'AdminEmail',
            'day' : 'AdminMemDateD',
            'month' : 'AdminMemDateM',
            'year' : 'AdminMemDateY'
        },
        'tech' : {
            'title' : 'TechTitle',
            'firstname' : 'TechFirstName',
            'lastname' : 'TechLastName',
            'organisation' : 'TechOrganization',
            'email' : 'TechEmail',
            'phonecc' : 'TechPhoneCC',
            'phoneac' : 'TechPhoneAC',
            'phonen' : 'TechPhoneN',
            'address1' : 'TechAddress1',
            'address2' : 'TechAddress2',
            'city' : 'TechCity',
            'state' : 'TechState',
            'postcode' : 'TechPostCode',
            'country' : 'TechCountry'
        },
        'techusereseller' : 'TechUseReseller',
        'product' : 'ProductName',
        'csr' : 'CSR',
        'domain' : 'Domain',
        'period' : 'ValidityPeriod',
        'insurance' : 'Insurance',
        'servercount' : 'ServerCount',
        'approver' : 'ApproverEmail',
        'special' : 'SpecialInstructions',
        'terms' : 'AgreedToTerms',
        'novalidation' : 'NoCSRValidation'
    }
}


BASE_ORDER_SCHEMA = {
    "type" : "object",
    "properties" : {
        "product" : {"type" : "string", 'enum' : PRODUCTS.keys()},
        "period" : {"type" : "integer", 'enum' : [ 1, 12, 24, 36, 48, 60, 72 ]},
        "approver" : {"type" : "string", "maxLength" : 40},
        "insurance" : {"type" : "integer", "maximum":1},
        "servercount" : {"type" : "integer"},
        "techusereseller" : {"type" : "integer", "maximum":1},
        "novalidation" : {"type" : "integer", "maximum":1},
    }
}

BASE_ADDRESS_SCHEMA = {
    "type" : "object",
    "properties" : {
        "title" : {"type" : "string", 'enum' : ['Mrs', 'Mr', 'Miss', 'Ms', 'Dr', 'Rev']},
        "firstname" : {"type" : "string", "maxLength" : 40},
        "lastname" : {"type" : "string", "maxLength" : 40},
        "organisation" : {"type" : "string", "maxLength" : 40},
        "email" : {"type" : "string", "maxLength" : 40},
        "phonecc" : {"type" : "string", "maxLength" : 6},
        "phoneac" : {"type" : "string", "maxLength" : 10},
        "phonen" : {"type" : "string", "maxLength" : 15},
        "address1" : {"type" : "string", "maxLength" : 200},
        "address2" : {"type" : "string", "maxLength" : 200},
        "city" : {"type" : "string", "maxLength" : 40},
        "state" : {"type" : "string", "maxLength" : 40},
        "postcode" : {"type" : "string", "maxLength" : 15},
        "country" : {"type" : "string", 'enum' :  COUNTRY_CODES},
    }
}

def validate_order(order, approvers):
    BASE_ORDER_SCHEMA["properties"]["approver"]["enum"] = approvers
    validate(order, BASE_ORDER_SCHEMA)

def validate_address(address):
    validate(address, BASE_ADDRESS_SCHEMA)
