from setuptools import setup, find_packages
from pathlib import Path

ROOT = Path(__file__).parent
long_description = (ROOT / "README.md").read_text(encoding="utf-8")

setup(
    name="python-tty",                 # PyPI 分发名（可以有连字符）
    version="0.1.0",                   # 先用手动版本；后续可切 tag 自动版本
    description="A multi-console TTY framework for complex CLI/TTY apps",
    long_description=long_description,
    long_description_content_type="text/markdown",
    author="ROOKIEMIE",
    url="https://github.com/ROOKIEMIE/python-tty",
    package_dir={"": "src"},
    packages=find_packages(where="src", exclude=("tests*", "demos*", "docs*")),
    include_package_data=True,
    python_requires=">=3.10",
    install_requires=[
        "prompt_toolkit>=3.0.32",
        "tqdm",
    ],
)
