#!/usr/bin/env python
#
# vim: sw=2 ts=2 sts=2
#
# Copyright 2007 The Python-Twitter Developers
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

'''A library that provides a Python interface to the Twitter API'''

__author__ = 'python-twitter@googlegroups.com'
__version__ = '2.1'

import json as simplejson

try:
  from hashlib import md5
except ImportError:
  from md5 import md5

from _file_cache import _FileCache
from error import TwitterError
from direct_message import DirectMessage
from hashtag import Hashtag
from parse_tweet import ParseTweet
from trend import Trend
from url import Url
from status import Status
from user import User, UserStatus
from list import List
from api import Api
