# Copyright (c) 2013 Yubico AB
# All rights reserved.
#
#   Redistribution and use in source and binary forms, with or
#   without modification, are permitted provided that the following
#   conditions are met:
#
#    1. Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#    2. Redistributions in binary form must reproduce the above
#       copyright notice, this list of conditions and the following
#       disclaimer in the documentation and/or other materials provided
#       with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
# FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
# COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
# BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
# ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

from u2flib_host.hid_transport import list_devices
import unittest


class HidTest(unittest.TestCase):
    def get_device(self):
        devs = list_devices()
        if len(devs) != 1:
            raise Exception("Tests require a single U2F HID device")
        return devs[0]

    def test_open_close(self):
        dev = self.get_device()
        for i in xrange(0, 10):
            dev.open()
            dev.close()

    def test_echo(self):
        msg1 = 'hello world!'
        msg2 = '            '
        msg3 = ''
        with self.get_device() as dev:
            resp1 = dev.send_apdu(0x40, 0, 0, msg1)
            resp2 = dev.send_apdu(0x40, 0, 0, msg2)
            resp3 = dev.send_apdu(0x40, 0, 0, msg3)
        assert resp1 == msg1
        assert resp2 == msg2
        assert resp3 == msg3
