"""
UBL data models.

This package contains all dataclass models for UBL elements, including
basic components, aggregate components, and document models.
"""

from .aggregate_components import (
    AccountingCustomerParty,
    AccountingSupplierParty,
    Address,
    Contact,
    Country,
    FinancialInstitution,
    FinancialInstitutionBranch,
    InvoiceLine,
    Item,
    LegalMonetaryTotal,
    Party,
    PartyIdentification,
    PartyLegalEntity,
    PartyName,
    PartyTaxScheme,
    PayeeFinancialAccount,
    PaymentMeans,
    PostalAddress,
    Price,
    SellersItemIdentification,
    TaxCategory,
    TaxScheme,
    TaxSubtotal,
    TaxTotal,
)
from .basic_components import (
    AdditionalStreetName,
    AllowanceTotalAmount,
    Amount,
    BaseIdentifier,
    ChargeTotalAmount,
    CityName,
    Code,
    CompanyID,
    ConstantElement,
    CountrySubentity,
    CreditedQuantity,
    CustomizationID,
    Date,
    Description,
    DocumentCurrencyCode,
    DueDate,
    ElectronicMail,
    EndpointID,
    ID,
    Identifier,
    IdentificationCode,
    InvoiceTypeCode,
    InvoicedQuantity,
    IssueDate,
    LineCountNumeric,
    LineExtensionAmount,
    Name,
    Note,
    PayableAmount,
    PaymentDueDate,
    PaymentID,
    PaymentMeansCode,
    Percent,
    PostalZone,
    PriceAmount,
    ProfileID,
    Quantity,
    RegistrationName,
    StreetName,
    StrElement,
    TaxableAmount,
    TaxAmount,
    TaxCurrencyCode,
    TaxExclusiveAmount,
    TaxInclusiveAmount,
    Telephone,
    UBLVersionID,
    UUID,
)
from .common import (
    BaseElement,
    BaseXMLNS,
    CacMixin,
    CbcMixin,
    FromXMLMixin,
    ToXMLMixin,
    UblMixin,
    ValueStrMixin,
)
from .documents import BaseDocument, CreditNote, Invoice

__all__ = [
    # Basic components (base classes)
    "Amount",
    "BaseIdentifier",
    "Code",
    "CompanyID",
    "ConstantElement",
    "Date",
    "EndpointID",
    "ID",
    "Identifier",
    "IdentificationCode",
    "Name",
    "Percent",
    "Quantity",
    "StrElement",
    # Basic components (string value elements)
    "AdditionalStreetName",
    "CityName",
    "CountrySubentity",
    "Description",
    "ElectronicMail",
    "Note",
    "PostalZone",
    "RegistrationName",
    "StreetName",
    "Telephone",
    # Basic components (Amount subclasses)
    "AllowanceTotalAmount",
    "ChargeTotalAmount",
    "LineExtensionAmount",
    "PayableAmount",
    "PriceAmount",
    "TaxableAmount",
    "TaxAmount",
    "TaxExclusiveAmount",
    "TaxInclusiveAmount",
    # Basic components (Quantity subclasses)
    "CreditedQuantity",
    "InvoicedQuantity",
    # Basic components (Document-level elements)
    "CustomizationID",
    "DocumentCurrencyCode",
    "DueDate",
    "InvoiceTypeCode",
    "IssueDate",
    "LineCountNumeric",
    "PaymentDueDate",
    "PaymentID",
    "PaymentMeansCode",
    "ProfileID",
    "TaxCurrencyCode",
    "UBLVersionID",
    "UUID",
    # Aggregate components
    "AccountingCustomerParty",
    "AccountingSupplierParty",
    "Address",
    "Contact",
    "Country",
    "FinancialInstitution",
    "FinancialInstitutionBranch",
    "InvoiceLine",
    "Item",
    "LegalMonetaryTotal",
    "Party",
    "PartyIdentification",
    "PartyLegalEntity",
    "PartyName",
    "PartyTaxScheme",
    "PayeeFinancialAccount",
    "PaymentMeans",
    "PostalAddress",
    "Price",
    "SellersItemIdentification",
    "TaxCategory",
    "TaxScheme",
    "TaxSubtotal",
    "TaxTotal",
    # Document models
    "BaseDocument",
    "CreditNote",
    "Invoice",
    # Base classes and mixins
    "BaseElement",
    "BaseXMLNS",
    "CacMixin",
    "CbcMixin",
    "FromXMLMixin",
    "ToXMLMixin",
    "UblMixin",
    "ValueStrMixin",
]
