/*
THIS IS A GENERATED/BUNDLED FILE BY ROLLUP
if you want to view the source visit the plugins github repository
*/

"use strict";

var obsidian = require("obsidian");
var state = require("@codemirror/state");
var view = require("@codemirror/view");

/*! *****************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */

function __awaiter(thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P
      ? value
      : new P(function (resolve) {
          resolve(value);
        });
  }
  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }
    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }
    function step(result) {
      result.done
        ? resolve(result.value)
        : adopt(result.value).then(fulfilled, rejected);
    }
    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
}

const DEFAULT_SETTINGS = {
  useMathKeyboardShortcut_toggle: false,
  moveIntoMath_toggle: true,
  autoCloseMath_toggle: true,
  autoCloseRound_toggle: true,
  autoCloseSquare_toggle: true,
  autoCloseCurly_toggle: true,
  addAlignBlock_toggle: true,
  addAlignBlock_parameter: "align*",
  autoAlignSymbols: "= > < \\le \\ge \\neq \\approx",
  addCasesBlock_toggle: true,
  shiftEnter_toggle: false,
  addMatrixBlock_toggle: true,
  addMatrixBlock_parameter: "pmatrix",
  autoFraction_toggle: true,
  autoLargeBracket_toggle: true,
  autoSumLimit_toggle: true,
  autoEncloseSup_toggle: true,
  autoEncloseSub_toggle: true,
  encloseSelection_toggle: true,
  autoGreekCommandMathMode_toggle: true,
  customShorthand_toggle: true,
  useTabtoComplete_toggle: false,
  customShorthand_parameter:
    "bi:::\\binom{#cursor}{#tab};\nsq:::\\sqrt{};\nbb:::\\mathbb{};\nbf:::\\mathbf{};\nte:::\\text{};\ninf:::\\infty;\n" +
    "cd:::\\cdot;\nqu:::\\quad;\nti:::\\times;\n" +
    "al:::\\alpha;\nbe:::\\beta;\nga:::\\gamma;\nGa:::\\Gamma;\n" +
    "de:::\\delta;\nDe:::\\Delta;\nep:::\\epsilon;\nze:::\\zeta;\n" +
    "et:::\\eta;\nth:::\\theta;\nTh:::\\Theta;\nio:::\\iota;\n" +
    "ka:::\\kappa;\nla:::\\lambda;\nLa:::\\Lambda;\nmu:::\\mu;\n" +
    "nu:::\\nu;\nxi:::\\xi;\nXi:::\\Xi;\npi:::\\pi;\nPi:::\\Pi;\n" +
    "rh:::\\rho;\nsi:::\\sigma;\nSi:::\\Sigma;\nta:::\\tau;\n" +
    "up:::\\upsilon;\nUp:::\\Upsilon;\nph:::\\phi;\nPh:::\\Phi;\nch:::\\chi;\n" +
    "ps:::\\psi;\nPs:::\\Psi;\nom:::\\omega;\nOm:::\\Omega",
};
class QuickLatexPlugin extends obsidian.Plugin {
  constructor() {
    super(...arguments);
    this.vimAllow_autoCloseMath = true;
    this.makeExtensionThing = () =>
      state.Prec.high(
        view.keymap.of([
          {
            key: "$",
            run: () => {
              const view = this.app.workspace.getActiveViewOfType(
                obsidian.MarkdownView,
              );
              if (!view) return false;
              const editor = view.editor;
              if (editor.getSelection().length > 0) {
                // enclose selected text
                if (this.settings.encloseSelection_toggle) {
                  const anchor = editor.getCursor("anchor");
                  const head = editor.getCursor("head");
                  editor.replaceSelection(`$${editor.getSelection()}$`);
                  if (anchor.line > head.line) {
                    editor.setSelection(
                      { line: anchor.line, ch: anchor.ch },
                      { line: head.line, ch: head.ch + 1 },
                    );
                  } else if (anchor.line < head.line) {
                    editor.setSelection(
                      { line: anchor.line, ch: anchor.ch + 1 },
                      { line: head.line, ch: head.ch },
                    );
                  } else {
                    editor.setSelection(
                      { line: anchor.line, ch: anchor.ch + 1 },
                      { line: head.line, ch: head.ch + 1 },
                    );
                  }
                  return true;
                }
                return false;
              } else {
                // close math symbol
                const position = editor.getCursor();
                const prev_char = editor.getRange(
                  { line: position.line, ch: position.ch - 1 },
                  { line: position.line, ch: position.ch },
                );
                const next_char = editor.getRange(
                  { line: position.line, ch: position.ch },
                  { line: position.line, ch: position.ch + 1 },
                );
                const next2_char = editor.getRange(
                  { line: position.line, ch: position.ch },
                  { line: position.line, ch: position.ch + 2 },
                );
                if (prev_char != "$" && next_char == "$") {
                  if (next2_char == "$$") {
                    editor.setCursor({
                      line: position.line,
                      ch: position.ch + 2,
                    });
                    return true;
                  } else {
                    editor.setCursor({
                      line: position.line,
                      ch: position.ch + 1,
                    });
                    return true;
                  }
                }
                // auto close math
                if (
                  this.settings.autoCloseMath_toggle &&
                  this.vimAllow_autoCloseMath
                ) {
                  const prev_char = editor.getRange(
                    { line: position.line, ch: position.ch - 1 },
                    { line: position.line, ch: position.ch },
                  );
                  const line = editor.getLine(position.line);
                  const count = (line.match(/\$/g) || []).length;
                  if (prev_char != "\\" && count % 2 == 0) {
                    editor.replaceSelection("$");
                  }
                }
                // move into math
                if (this.settings.moveIntoMath_toggle) {
                  const position = editor.getCursor();
                  const t = editor.getRange(
                    { line: position.line, ch: position.ch - 1 },
                    { line: position.line, ch: position.ch },
                  );
                  const t2 = editor.getRange(
                    { line: position.line, ch: position.ch },
                    { line: position.line, ch: position.ch + 1 },
                  );
                  const t_2 = editor.getRange(
                    { line: position.line, ch: position.ch - 2 },
                    { line: position.line, ch: position.ch },
                  );
                  if (t == "$" && t2 != "$") {
                    editor.setCursor({
                      line: position.line,
                      ch: position.ch - 1,
                    });
                  } else if (t_2 == "$$") {
                    editor.setCursor({
                      line: position.line,
                      ch: position.ch - 1,
                    });
                  }
                }
                return false;
              }
            },
          },
          // delete pair of math symbols with backspace
          {
            key: "Backspace",
            run: () => {
              const view = this.app.workspace.getActiveViewOfType(
                obsidian.MarkdownView,
              );
              if (!view) return false;
              const editor = view.editor;
              const position = editor.getCursor();
              const prev_char = editor.getRange(
                { line: position.line, ch: position.ch - 1 },
                { line: position.line, ch: position.ch },
              );
              const next_char = editor.getRange(
                { line: position.line, ch: position.ch },
                { line: position.line, ch: position.ch + 1 },
              );
              if (prev_char == "$" && next_char == "$") {
                editor.replaceRange(
                  "",
                  { line: position.line, ch: position.ch - 1 },
                  { line: position.line, ch: position.ch + 1 },
                );
                return true;
              }
              return false;
            },
          },
          {
            key: "Tab",
            run: () => {
              const view = this.app.workspace.getActiveViewOfType(
                obsidian.MarkdownView,
              );
              if (!view) return false;
              const editor = view.editor;
              if (this.withinMath(editor)) {
                const position = editor.getCursor();
                const current_line = editor.getLine(position.line);
                const end_pos = editor.getLine(position.line).length;
                const next_line = editor.getLine(position.line + 1);
                // check for custom shorthand
                if (
                  this.settings.customShorthand_toggle &&
                  !this.withinText(editor, position.ch)
                ) {
                  if (this.settings.useTabtoComplete_toggle) {
                    if (this.customShorthand(editor, position)) {
                      return true;
                    }
                  }
                }
                // Tab to go to next #tab with numbering or without numbering if there are no #tabs with numbers
                const indexed_tab_expr = /#tab(\d+)?/g;
                let next_match;
                let current_match;
                while (
                  (current_match = indexed_tab_expr.exec(current_line)) != null
                ) {
                  if (
                    !next_match ||
                    parseInt(current_match[1]) < parseInt(next_match[1])
                  )
                    next_match = current_match;
                }
                if (next_match) {
                  const tab_position = next_match.index;
                  editor.replaceRange(
                    "",
                    { line: position.line, ch: tab_position },
                    {
                      line: position.line,
                      ch: tab_position + next_match[0].length,
                    },
                  );
                  editor.setCursor({ line: position.line, ch: tab_position });
                  return true;
                }
                // Tab shortcut for matrix block
                if (this.settings.addMatrixBlock_toggle) {
                  const begin_matrix = [
                    "\\begin{" + this.settings.addMatrixBlock_parameter + "}",
                    "\\begin{matrix}",
                    "\\begin{bmatrix}",
                    "\\begin{Bmatrix}",
                    "\\begin{vmatrix}",
                    "\\begin{Vmatrix}",
                    "\\begin{smallmatrix}",
                  ];
                  const end_matrix = [
                    "\\end{" + this.settings.addMatrixBlock_parameter + "}",
                    "\\end{matrix}",
                    "\\end{bmatrix}",
                    "\\end{Bmatrix}",
                    "\\end{vmatrix}",
                    "\\end{Vmatrix}",
                    "\\end{smallmatrix}",
                  ];
                  let state = false;
                  let end_text = "";
                  for (let i = 0; i < begin_matrix.length; i++) {
                    if (
                      this.withinAnyBrackets_document(
                        editor,
                        begin_matrix[i],
                        end_matrix[i],
                      )
                    ) {
                      state = true;
                      end_text = end_matrix[i];
                      break;
                    }
                  }
                  const position = editor.getCursor();
                  const prev3_char = editor.getRange(
                    { line: position.line, ch: position.ch - 3 },
                    { line: position.line, ch: position.ch },
                  );
                  if (state) {
                    if (prev3_char == " & ") {
                      editor.replaceRange(
                        "",
                        { line: position.line, ch: position.ch - 3 },
                        { line: position.line, ch: position.ch },
                      );
                      editor.setCursor({
                        line: position.line,
                        ch: position.ch + end_text.length - 3,
                      });
                      return true;
                    } else {
                      editor.replaceSelection(" & ");
                      return true;
                    }
                  }
                }
                // Tab shortcut for cases block
                if (this.settings.addCasesBlock_toggle) {
                  if (
                    this.withinAnyBrackets_document(
                      editor,
                      "\\begin{cases}",
                      "\\end{cases}",
                    )
                  ) {
                    const position = editor.getCursor();
                    const prev3_char = editor.getRange(
                      { line: position.line, ch: position.ch - 3 },
                      { line: position.line, ch: position.ch },
                    );
                    const next_line = editor.getLine(position.line + 1);
                    if (prev3_char == " & " && next_line == "\\end{cases}") {
                      editor.replaceRange(
                        "",
                        { line: position.line, ch: position.ch - 3 },
                        { line: position.line, ch: position.ch },
                      );
                      editor.setCursor({
                        line: position.line + 1,
                        ch: next_line.length,
                      });
                      return true;
                    } else {
                      editor.replaceSelection(" & ");
                      return true;
                    }
                  }
                }
                // Tab out of $
                const next_2 = editor.getRange(
                  { line: position.line, ch: position.ch },
                  { line: position.line, ch: position.ch + 2 },
                );
                if (next_2 == "$$") {
                  editor.setCursor({
                    line: position.line,
                    ch: position.ch + 2,
                  });
                  return true;
                } else if (position.ch == end_pos && next_line == "$$") {
                  editor.setCursor({
                    line: position.line + 1,
                    ch: next_line.length,
                  });
                  return true;
                } else if (next_2[0] == "$") {
                  editor.setCursor({
                    line: position.line,
                    ch: position.ch + 1,
                  });
                  return true;
                }
                // Tab to next close bracket
                const following_text = editor.getRange(
                  { line: position.line, ch: position.ch + 1 },
                  { line: position.line, ch: current_line.length },
                );
                const close_symbols = ["}", "]", ")", "$"];
                for (let i = 0; i < following_text.length; i++) {
                  if (close_symbols.contains(following_text[i])) {
                    editor.setCursor({
                      line: position.line,
                      ch: position.ch + i + 1,
                    });
                    return true;
                  }
                }
                // Tab out of align block
                if (
                  position.ch == end_pos &&
                  next_line ==
                    "\\end{" + this.settings.addAlignBlock_parameter + "}"
                ) {
                  editor.setCursor({
                    line: position.line + 1,
                    ch: next_line.length,
                  });
                  return true;
                }
              }
              return false;
            },
          },
          {
            key: "Shift-Tab",
            run: () => {
              const view = this.app.workspace.getActiveViewOfType(
                obsidian.MarkdownView,
              );
              if (!view) return false;
              const editor = view.editor;
              if (this.withinMath(editor)) {
                const position = editor.getCursor();
                const preceding_text = editor.getRange(
                  { line: position.line, ch: 0 },
                  { line: position.line, ch: position.ch },
                );
                const close_symbols = ["}", "]", ")"];
                for (let i = preceding_text.length; i >= 0; i--) {
                  if (close_symbols.contains(preceding_text[i])) {
                    editor.setCursor({ line: position.line, ch: i });
                    return true;
                  } else if (position.ch - i > 1 && preceding_text[i] == "$") {
                    editor.setCursor({ line: position.line, ch: i + 1 });
                    return true;
                  } else if (preceding_text.slice(-2) == "$$") {
                    editor.setCursor({
                      line: position.line,
                      ch: position.ch - 2,
                    });
                    return true;
                  } else if (preceding_text[-1] == "$") {
                    editor.setCursor({
                      line: position.line,
                      ch: position.ch - 1,
                    });
                    return true;
                  }
                }
              }
              return false;
            },
          },
          {
            key: "Space",
            run: () => {
              const view = this.app.workspace.getActiveViewOfType(
                obsidian.MarkdownView,
              );
              if (!view) return false;
              const editor = view.editor;
              if (
                !this.settings.autoFraction_toggle &&
                !this.settings.autoLargeBracket_toggle &&
                !this.settings.autoEncloseSup_toggle &&
                !this.settings.autoEncloseSub_toggle &&
                !this.settings.customShorthand_toggle
              )
                return false;
              if (this.withinMath(editor)) {
                const position = editor.getCursor();
                const current_line = editor.getLine(position.line);
                const last_dollar = current_line.lastIndexOf(
                  "$",
                  position.ch - 1,
                );
                // check for custom shorthand
                if (
                  this.settings.customShorthand_toggle &&
                  !this.withinText(editor, position.ch)
                ) {
                  if (!this.settings.useTabtoComplete_toggle) {
                    if (this.customShorthand(editor, position)) {
                      return true;
                    }
                  }
                }
                // find last unbracketed subscript within last 10 characters and perform autoEncloseSub
                // ignore expression that contain + - * / ^
                const last_math = current_line.lastIndexOf(
                  "$",
                  position.ch - 1,
                );
                if (this.settings.autoEncloseSub_toggle) {
                  let last_subscript = current_line.lastIndexOf(
                    "_",
                    position.ch,
                  );
                  if (last_subscript != -1 && last_subscript > last_math) {
                    const letter_after_subscript = editor.getRange(
                      { line: position.line, ch: last_subscript + 1 },
                      { line: position.line, ch: last_subscript + 2 },
                    );
                    if (
                      letter_after_subscript != "{" &&
                      position.ch - last_subscript <= 10
                    ) {
                      editor.replaceSelection("}");
                      editor.replaceRange("{", {
                        line: position.line,
                        ch: last_subscript + 1,
                      });
                      return true;
                    }
                  }
                }
                // retrieve the last unbracketed superscript
                let last_superscript = current_line.lastIndexOf(
                  "^",
                  position.ch,
                );
                while (last_superscript != -1) {
                  const two_letters_after_superscript = editor.getRange(
                    { line: position.line, ch: last_superscript + 1 },
                    { line: position.line, ch: last_superscript + 3 },
                  );
                  if (
                    two_letters_after_superscript[0] == "{" ||
                    two_letters_after_superscript == " {"
                  ) {
                    last_superscript = current_line.lastIndexOf(
                      "^",
                      last_superscript - 1,
                    );
                  } else if (last_superscript < last_math) {
                    last_superscript = -1;
                    break;
                  } else {
                    break;
                  }
                }
                // retrieve the last divide symbol
                let last_divide = current_line.lastIndexOf(
                  "/",
                  position.ch - 2,
                );
                while (last_divide != -1) {
                  const around_divide = editor.getRange(
                    { line: position.line, ch: last_divide - 1 },
                    { line: position.line, ch: last_divide + 2 },
                  );
                  if (around_divide[0] == " " && around_divide[2] == " ") {
                    last_divide = current_line.lastIndexOf(
                      "^",
                      last_divide - 1,
                    );
                  } else if (last_divide < last_math) {
                    last_divide = -1;
                    break;
                  } else {
                    break;
                  }
                }
                // perform autoEncloseSup
                if (this.settings.autoEncloseSup_toggle) {
                  if (last_superscript > last_divide) {
                    // if any brackets from last sup to cursor still unclosed, dont do autoEncloseSup yet
                    const brackets = [
                      ["(", ")"],
                      ["{", "}"],
                      ["[", "]"],
                    ];
                    if (
                      !brackets.some(
                        (e) =>
                          this.unclosed_bracket(
                            editor,
                            e[0],
                            e[1],
                            position.ch,
                            last_superscript,
                          )[0],
                      )
                    ) {
                      return this.autoEncloseSup(
                        editor,
                        event,
                        last_superscript,
                      );
                    }
                  }
                }
                // perform autoFraction
                if (
                  this.settings.autoFraction_toggle &&
                  !this.withinText(editor, last_divide)
                ) {
                  if (last_divide > last_dollar) {
                    const brackets = [
                      ["(", ")"],
                      ["{", "}"],
                      ["[", "]"],
                    ];
                    // if any brackets in denominator still unclosed, dont do autoFraction yet
                    if (
                      !brackets.some(
                        (e) =>
                          this.unclosed_bracket(
                            editor,
                            e[0],
                            e[1],
                            position.ch,
                            last_divide,
                          )[0],
                      )
                    ) {
                      return this.autoFractionCM6(editor, last_superscript);
                    }
                  }
                }
                // perform autoLargeBracket
                if (this.settings.autoLargeBracket_toggle) {
                  let symbol_before = editor.getRange(
                    { line: position.line, ch: position.ch - 1 },
                    { line: position.line, ch: position.ch },
                  );
                  if (symbol_before == ")" || symbol_before == "]") {
                    return this.autoLargeBracket(editor, event);
                  }
                }
                // perform autoAlign
                if (this.autoAlign_array.length) {
                  if (
                    this.withinAnyBrackets_document(
                      editor,
                      "\\begin{" + this.settings.addAlignBlock_parameter,
                      "\\end{" + this.settings.addAlignBlock_parameter,
                    )
                  ) {
                    let keyword = "";
                    let keyword_length = 0;
                    for (let i = 0; i < this.autoAlign_array.length; i++) {
                      keyword_length = this.autoAlign_array[i].length;
                      if (keyword_length > position.ch) {
                        continue;
                      } else {
                        keyword = editor.getRange(
                          {
                            line: position.line,
                            ch: position.ch - keyword_length,
                          },
                          { line: position.line, ch: position.ch },
                        );
                      }
                      if (keyword == this.autoAlign_array[i]) {
                        editor.replaceRange("&", {
                          line: position.line,
                          ch: position.ch - keyword_length,
                        });
                        return false;
                      }
                    }
                  }
                }
              } else if (this.settings.autoGreekCommandMathMode_toggle) {
                const greekSymbols = [
                  "alpha",
                  "Alpha",
                  "beta",
                  "gamma",
                  "Gamma",
                  "delta",
                  "Delta",
                  "epsilon",
                  "zeta",
                  "eta",
                  "theta",
                  "Theta",
                  "iota",
                  "kappa",
                  "lambda",
                  "Lambda",
                  "mu",
                  "nu",
                  "xi",
                  "Xi",
                  "omicron",
                  "pi",
                  "Pi",
                  "rho",
                  "sigma",
                  "Sigma",
                  "tau",
                  "upsilon",
                  "Upsilon",
                  "phi",
                  "Phi",
                  "chi",
                  "psi",
                  "Psi",
                  "omega",
                  "Omega",
                  "varepsilon",
                  "vartheta",
                  "varrho",
                  "varphi",
                ];
                const greekSymbolsSlashed = greekSymbols.map((x) => "\\" + x);
                const position = editor.getCursor();
                const current_line = editor.getLine(position.line);
                const last_slash = current_line.lastIndexOf(
                  "\\",
                  position.ch - 1,
                );
                if (last_slash != -1) {
                  const entered = current_line.substring(
                    last_slash,
                    position.ch,
                  );
                  if (greekSymbolsSlashed.contains(entered))
                    editor.replaceRange(
                      "$" + entered + "$",
                      { line: position.line, ch: position.ch - entered.length },
                      { line: position.line, ch: position.ch },
                    );
                }
              }
            },
          },
          {
            key: "Shift-Space",
            run: () => {
              const view = this.app.workspace.getActiveViewOfType(
                obsidian.MarkdownView,
              );
              if (!view) return false;
              const editor = view.editor;
              if (!this.settings.customShorthand_toggle) return false;
              if (this.withinMath(editor)) {
                const position = editor.getCursor();
                // check for custom shorthand
                if (
                  this.settings.customShorthand_toggle &&
                  !this.withinText(editor, position.ch)
                ) {
                  let keyword = "";
                  let keyword_length = 0;
                  for (let i = 0; i < this.shorthand_array.length; i++) {
                    keyword_length = this.shorthand_array[i][0].length;
                    if (keyword_length > position.ch) {
                      continue;
                    } else if (keyword_length == position.ch) {
                      keyword =
                        "@" +
                        editor.getRange(
                          {
                            line: position.line,
                            ch: position.ch - keyword_length,
                          },
                          { line: position.line, ch: position.ch },
                        );
                    } else {
                      keyword = editor.getRange(
                        {
                          line: position.line,
                          ch: position.ch - keyword_length - 1,
                        },
                        { line: position.line, ch: position.ch },
                      );
                    }
                    if (
                      keyword[0].toLowerCase() == keyword[0].toUpperCase() ||
                      keyword[0] == "@"
                    ) {
                      if (
                        this.shorthand_array[i][0] ==
                          keyword.slice(-keyword_length) &&
                        this.shorthand_array[i][1] != keyword
                      ) {
                        const replace_slash =
                          keyword[0] == "\\" &&
                          this.shorthand_array[i][1][0] == "\\"
                            ? 1
                            : 0;
                        const set_cursor_position =
                          this.shorthand_array[i][1].indexOf("#cursor");
                        editor.replaceRange(
                          this.shorthand_array[i][1],
                          {
                            line: position.line,
                            ch: position.ch - keyword_length - replace_slash,
                          },
                          { line: position.line, ch: position.ch },
                        );
                        if (set_cursor_position != -1) {
                          editor.replaceRange(
                            "",
                            {
                              line: position.line,
                              ch:
                                position.ch -
                                keyword_length -
                                replace_slash +
                                set_cursor_position,
                            },
                            {
                              line: position.line,
                              ch:
                                position.ch -
                                keyword_length -
                                replace_slash +
                                set_cursor_position +
                                7,
                            },
                          );
                          editor.setCursor({
                            line: position.line,
                            ch:
                              position.ch -
                              keyword_length -
                              replace_slash +
                              set_cursor_position,
                          });
                        } else if (
                          this.shorthand_array[i][1].slice(-2) == "{}"
                        ) {
                          editor.setCursor({
                            line: position.line,
                            ch:
                              position.ch +
                              this.shorthand_array[i][1].length -
                              keyword_length -
                              1 -
                              replace_slash,
                          });
                        } else;
                        return true;
                      }
                    }
                  }
                }
              }
            },
          },
          {
            key: "Enter",
            run: () => {
              const view = this.app.workspace.getActiveViewOfType(
                obsidian.MarkdownView,
              );
              if (!view) return false;
              const editor = view.editor;
              if (
                this.settings.addAlignBlock_toggle &&
                this.settings.shiftEnter_toggle == false
              ) {
                if (
                  this.withinAnyBrackets_document(
                    editor,
                    "\\begin{" + this.settings.addAlignBlock_parameter,
                    "\\end{" + this.settings.addAlignBlock_parameter,
                  )
                ) {
                  editor.replaceSelection("\\\\\n");
                  return true;
                }
              }
              if (
                this.settings.addCasesBlock_toggle &&
                this.settings.shiftEnter_toggle == false
              ) {
                if (
                  this.withinAnyBrackets_document(
                    editor,
                    "\\begin{cases}",
                    "\\end{cases}",
                  )
                ) {
                  editor.replaceSelection(" \\\\\n");
                  return true;
                }
              }
              if (this.settings.addMatrixBlock_toggle) {
                const begin_matrix = [
                  "\\begin{" + this.settings.addMatrixBlock_parameter + "}",
                  "\\begin{matrix}",
                  "\\begin{bmatrix}",
                  "\\begin{Bmatrix}",
                  "\\begin{vmatrix}",
                  "\\begin{Vmatrix}",
                  "\\begin{smallmatrix}",
                ];
                const end_matrix = [
                  "\\end{" + this.settings.addMatrixBlock_parameter + "}",
                  "\\end{matrix}",
                  "\\end{bmatrix}",
                  "\\end{Bmatrix}",
                  "\\end{vmatrix}",
                  "\\end{Vmatrix}",
                  "\\end{smallmatrix}",
                ];
                let state = false;
                for (let i = 0; i < begin_matrix.length; i++) {
                  if (
                    this.withinAnyBrackets_document(
                      editor,
                      begin_matrix[i],
                      end_matrix[i],
                    )
                  ) {
                    state = true;
                    break;
                  }
                }
                if (state) {
                  editor.replaceSelection(" \\\\ ");
                  return true;
                }
              }
              // double enter for $$
              if (this.withinMath(editor)) {
                const position = editor.getCursor();
                const prev2_Char = editor.getRange(
                  { line: position.line, ch: position.ch - 2 },
                  { line: position.line, ch: position.ch },
                );
                const next2_Char = editor.getRange(
                  { line: position.line, ch: position.ch },
                  { line: position.line, ch: position.ch + 2 },
                );
                if (prev2_Char == "$$" && next2_Char == "$$") {
                  editor.replaceSelection("\n");
                  editor.setCursor(position);
                  return false;
                }
              }
              return false;
            },
          },
          {
            key: "Shift-Enter",
            run: () => {
              const view = this.app.workspace.getActiveViewOfType(
                obsidian.MarkdownView,
              );
              if (!view) return false;
              const editor = view.editor;
              if (
                this.settings.addAlignBlock_toggle &&
                this.settings.shiftEnter_toggle == true
              ) {
                if (
                  this.withinAnyBrackets_document(
                    editor,
                    "\\begin{" + this.settings.addAlignBlock_parameter,
                    "\\end{" + this.settings.addAlignBlock_parameter,
                  )
                ) {
                  editor.replaceSelection("\\\\\n");
                  return true;
                }
              }
              if (
                this.settings.addCasesBlock_toggle &&
                this.settings.shiftEnter_toggle == true
              ) {
                if (
                  this.withinAnyBrackets_document(
                    editor,
                    "\\begin{cases}",
                    "\\end{cases}",
                  )
                ) {
                  editor.replaceSelection(" \\\\\n");
                  return true;
                }
              }
              return false;
            },
          },
          {
            key: "{",
            run: () => {
              const view = this.app.workspace.getActiveViewOfType(
                obsidian.MarkdownView,
              );
              if (!view) return false;
              const editor = view.editor;
              if (this.withinMath(editor)) {
                if (this.settings.autoCloseCurly_toggle) {
                  if (editor.getSelection().length > 0) {
                    return false;
                  }
                  const position = editor.getCursor();
                  const brackets = [
                    ["(", ")"],
                    ["{", "}"],
                    ["[", "]"],
                  ];
                  const next_char = editor.getRange(
                    { line: position.line, ch: position.ch },
                    { line: position.line, ch: position.ch + 1 },
                  );
                  const next_2char = editor.getRange(
                    { line: position.line, ch: position.ch },
                    { line: position.line, ch: position.ch + 2 },
                  );
                  const followed_by_$spacetabnonedoubleslash =
                    ["$", " ", "	", ""].contains(next_char) ||
                    next_2char == "\\\\";
                  if (
                    !this.withinAnyBrackets_inline(editor, brackets) &&
                    followed_by_$spacetabnonedoubleslash
                  ) {
                    editor.replaceSelection("{}");
                    editor.setCursor({
                      line: position.line,
                      ch: position.ch + 1,
                    });
                    return true;
                  }
                }
              }
              return false;
            },
          },
          {
            key: "[",
            run: () => {
              const view = this.app.workspace.getActiveViewOfType(
                obsidian.MarkdownView,
              );
              if (!view) return false;
              const editor = view.editor;
              if (this.withinMath(editor)) {
                if (this.settings.autoCloseSquare_toggle) {
                  if (editor.getSelection().length > 0) {
                    return false;
                  }
                  const position = editor.getCursor();
                  const brackets = [
                    ["(", ")"],
                    ["{", "}"],
                    ["[", "]"],
                  ];
                  const next_char = editor.getRange(
                    { line: position.line, ch: position.ch },
                    { line: position.line, ch: position.ch + 1 },
                  );
                  const next_2char = editor.getRange(
                    { line: position.line, ch: position.ch },
                    { line: position.line, ch: position.ch + 2 },
                  );
                  const followed_by_$spacetabnonedoubleslash =
                    ["$", " ", "	", ""].contains(next_char) ||
                    next_2char == "\\\\";
                  if (
                    !this.withinAnyBrackets_inline(editor, brackets) &&
                    followed_by_$spacetabnonedoubleslash
                  ) {
                    editor.replaceSelection("[]");
                    editor.setCursor({
                      line: position.line,
                      ch: position.ch + 1,
                    });
                    return true;
                  }
                }
              }
              return false;
            },
          },
          {
            key: "(",
            run: () => {
              const view = this.app.workspace.getActiveViewOfType(
                obsidian.MarkdownView,
              );
              if (!view) return false;
              const editor = view.editor;
              if (this.withinMath(editor)) {
                if (this.settings.autoCloseRound_toggle) {
                  if (editor.getSelection().length > 0) {
                    return false;
                  }
                  const position = editor.getCursor();
                  const brackets = [
                    ["(", ")"],
                    ["{", "}"],
                    ["[", "]"],
                  ];
                  const next_char = editor.getRange(
                    { line: position.line, ch: position.ch },
                    { line: position.line, ch: position.ch + 1 },
                  );
                  const next_2char = editor.getRange(
                    { line: position.line, ch: position.ch },
                    { line: position.line, ch: position.ch + 2 },
                  );
                  const followed_by_$spacetabnonedoubleslash =
                    ["$", " ", "	", ""].contains(next_char) ||
                    next_2char == "\\\\";
                  if (
                    !this.withinAnyBrackets_inline(editor, brackets) &&
                    followed_by_$spacetabnonedoubleslash
                  ) {
                    editor.replaceSelection("()");
                    editor.setCursor({
                      line: position.line,
                      ch: position.ch + 1,
                    });
                    return true;
                  }
                }
              }
              return false;
            },
          },
          {
            key: "}",
            run: () => {
              const view = this.app.workspace.getActiveViewOfType(
                obsidian.MarkdownView,
              );
              if (!view) return false;
              const editor = view.editor;
              if (this.withinMath(editor)) {
                if (this.settings.autoCloseCurly_toggle) {
                  const position = editor.getCursor();
                  const end = editor.getLine(position.line).length;
                  const next_sym = editor.getRange(
                    { line: position.line, ch: position.ch },
                    { line: position.line, ch: position.ch + 1 },
                  );
                  if (
                    !this.unclosed_bracket(editor, "{", "}", end, 0)[0] &&
                    !this.unclosed_bracket(
                      editor,
                      "{",
                      "}",
                      end,
                      0,
                      false,
                    )[0] &&
                    next_sym == "}"
                  ) {
                    editor.setCursor({
                      line: position.line,
                      ch: position.ch + 1,
                    });
                    return true;
                  } else {
                    return false;
                  }
                }
              }
              return false;
            },
          },
          {
            key: "]",
            run: () => {
              const view = this.app.workspace.getActiveViewOfType(
                obsidian.MarkdownView,
              );
              if (!view) return false;
              const editor = view.editor;
              if (this.withinMath(editor)) {
                if (this.settings.autoCloseSquare_toggle) {
                  const position = editor.getCursor();
                  const end = editor.getLine(position.line).length;
                  const next_sym = editor.getRange(
                    { line: position.line, ch: position.ch },
                    { line: position.line, ch: position.ch + 1 },
                  );
                  if (
                    !this.unclosed_bracket(editor, "[", "]", end, 0)[0] &&
                    !this.unclosed_bracket(
                      editor,
                      "[",
                      "]",
                      end,
                      0,
                      false,
                    )[0] &&
                    next_sym == "]"
                  ) {
                    editor.setCursor({
                      line: position.line,
                      ch: position.ch + 1,
                    });
                    return true;
                  } else {
                    return false;
                  }
                }
              }
              return false;
            },
          },
          {
            key: ")",
            run: () => {
              const view = this.app.workspace.getActiveViewOfType(
                obsidian.MarkdownView,
              );
              if (!view) return false;
              const editor = view.editor;
              if (this.withinMath(editor)) {
                if (this.settings.autoCloseRound_toggle) {
                  const position = editor.getCursor();
                  const end = editor.getLine(position.line).length;
                  const next_sym = editor.getRange(
                    { line: position.line, ch: position.ch },
                    { line: position.line, ch: position.ch + 1 },
                  );
                  if (
                    !this.unclosed_bracket(editor, "(", ")", end, 0)[0] &&
                    !this.unclosed_bracket(
                      editor,
                      "(",
                      ")",
                      end,
                      0,
                      false,
                    )[0] &&
                    next_sym == ")"
                  ) {
                    editor.setCursor({
                      line: position.line,
                      ch: position.ch + 1,
                    });
                    return true;
                  } else {
                    return false;
                  }
                }
              }
              return false;
            },
          },
          {
            key: "m",
            run: () => {
              const view = this.app.workspace.getActiveViewOfType(
                obsidian.MarkdownView,
              );
              if (!view) return false;
              const editor = view.editor;
              if (!this.withinMath(editor)) return false;
              const position = editor.getCursor();
              if (!this.settings.autoSumLimit_toggle) return;
              if (this.withinMath(editor)) {
                if (
                  editor.getRange(
                    { line: position.line, ch: position.ch - 3 },
                    { line: position.line, ch: position.ch },
                  ) == "\\su"
                ) {
                  editor.replaceSelection("m\\limits");
                  return true;
                }
              }
              return false;
            },
          },
        ]),
      );
    this.handleVimModeChange = (modeObj) => {
      if (!modeObj || modeObj.mode === "insert")
        this.vimAllow_autoCloseMath = true;
      else this.vimAllow_autoCloseMath = false;
    };
    this.handleKeyDown = (cm, event) => {
      const view = this.app.workspace.getActiveViewOfType(
        obsidian.MarkdownView,
      );
      if (!view) return;
      const editor = view.editor;
      if (["$", " ", "Enter", "Tab"].contains(event.key)) {
        switch (event.key) {
          case "$":
            if (editor.getSelection().length > 0) {
              if (this.settings.encloseSelection_toggle) {
                const anchor = editor.getCursor("anchor");
                const head = editor.getCursor("head");
                editor.replaceSelection("$" + editor.getSelection() + "$");
                if (anchor.line > head.line) {
                  editor.setSelection(
                    { line: anchor.line, ch: anchor.ch },
                    { line: head.line, ch: head.ch + 1 },
                  );
                } else if (anchor.line < head.line) {
                  editor.setSelection(
                    { line: anchor.line, ch: anchor.ch + 1 },
                    { line: head.line, ch: head.ch },
                  );
                } else {
                  editor.setSelection(
                    { line: anchor.line, ch: anchor.ch + 1 },
                    { line: head.line, ch: head.ch + 1 },
                  );
                }
                event.preventDefault();
                return;
              }
            } else {
              // close math symbol
              const position = editor.getCursor();
              const prev_char = editor.getRange(
                { line: position.line, ch: position.ch - 1 },
                { line: position.line, ch: position.ch },
              );
              const next_char = editor.getRange(
                { line: position.line, ch: position.ch },
                { line: position.line, ch: position.ch + 1 },
              );
              const next2_char = editor.getRange(
                { line: position.line, ch: position.ch },
                { line: position.line, ch: position.ch + 2 },
              );
              if (prev_char != "$" && next_char == "$") {
                if (next2_char == "$$") {
                  editor.setCursor({
                    line: position.line,
                    ch: position.ch + 2,
                  });
                  event.preventDefault();
                  return;
                } else {
                  editor.setCursor({
                    line: position.line,
                    ch: position.ch + 1,
                  });
                  event.preventDefault();
                  return;
                }
              }
              // perform autoCloseMath
              if (
                this.settings.autoCloseMath_toggle &&
                this.vimAllow_autoCloseMath
              ) {
                editor.replaceSelection("$");
              }
              // perform moveIntoMath
              if (this.settings.moveIntoMath_toggle) {
                const position = editor.getCursor();
                const t = editor.getRange(
                  { line: position.line, ch: position.ch - 1 },
                  { line: position.line, ch: position.ch },
                );
                const t2 = editor.getRange(
                  { line: position.line, ch: position.ch },
                  { line: position.line, ch: position.ch + 1 },
                );
                const t_2 = editor.getRange(
                  { line: position.line, ch: position.ch - 2 },
                  { line: position.line, ch: position.ch },
                );
                if (t == "$" && t2 != "$") {
                  editor.setCursor({
                    line: position.line,
                    ch: position.ch - 1,
                  });
                } else if (t_2 == "$$") {
                  editor.setCursor({
                    line: position.line,
                    ch: position.ch - 1,
                  });
                }
              }
            }
            return;
          case " ":
            if (
              !this.settings.autoFraction_toggle &&
              !this.settings.autoLargeBracket_toggle &&
              !this.settings.autoEncloseSup_toggle &&
              !this.settings.autoEncloseSub_toggle &&
              !this.settings.customShorthand_toggle
            )
              return;
            if (this.withinMath(editor)) {
              const position = editor.getCursor();
              const current_line = editor.getLine(position.line);
              const last_dollar = current_line.lastIndexOf(
                "$",
                position.ch - 1,
              );
              // check for custom shorthand
              if (
                this.settings.customShorthand_toggle &&
                !this.withinText(editor, position.ch)
              ) {
                let keyword = "";
                let keyword_length = 0;
                for (let i = 0; i < this.shorthand_array.length; i++) {
                  keyword_length = this.shorthand_array[i][0].length;
                  if (keyword_length > position.ch) {
                    continue;
                  } else if (keyword_length == position.ch) {
                    keyword =
                      "@" +
                      editor.getRange(
                        {
                          line: position.line,
                          ch: position.ch - keyword_length,
                        },
                        { line: position.line, ch: position.ch },
                      );
                  } else {
                    keyword = editor.getRange(
                      {
                        line: position.line,
                        ch: position.ch - keyword_length - 1,
                      },
                      { line: position.line, ch: position.ch },
                    );
                  }
                  if (
                    keyword[0].toLowerCase() == keyword[0].toUpperCase() ||
                    keyword[0] == "@"
                  ) {
                    if (
                      this.shorthand_array[i][0] ==
                        keyword.slice(-keyword_length) &&
                      this.shorthand_array[i][1] != keyword
                    ) {
                      const replace_slash =
                        keyword[0] == "\\" &&
                        this.shorthand_array[i][1][0] == "\\"
                          ? 1
                          : 0;
                      const set_cursor_position =
                        this.shorthand_array[i][1].indexOf("#cursor");
                      editor.replaceRange(
                        this.shorthand_array[i][1],
                        {
                          line: position.line,
                          ch: position.ch - keyword_length - replace_slash,
                        },
                        { line: position.line, ch: position.ch },
                      );
                      if (set_cursor_position != -1) {
                        editor.replaceRange(
                          "",
                          {
                            line: position.line,
                            ch:
                              position.ch -
                              keyword_length -
                              replace_slash +
                              set_cursor_position,
                          },
                          {
                            line: position.line,
                            ch:
                              position.ch -
                              keyword_length -
                              replace_slash +
                              set_cursor_position +
                              7,
                          },
                        );
                        editor.setCursor({
                          line: position.line,
                          ch:
                            position.ch -
                            keyword_length -
                            replace_slash +
                            set_cursor_position,
                        });
                      } else if (this.shorthand_array[i][1].slice(-2) == "{}") {
                        editor.setCursor({
                          line: position.line,
                          ch:
                            position.ch +
                            this.shorthand_array[i][1].length -
                            keyword_length -
                            1 -
                            replace_slash,
                        });
                      } else;
                      event.preventDefault();
                      return;
                    }
                  }
                }
              }
              // find last unbracketed subscript within last 10 characters and perform autoEncloseSub
              // ignore expression that contain + - * / ^
              const last_math = current_line.lastIndexOf("$", position.ch - 1);
              if (this.settings.autoEncloseSub_toggle) {
                let last_subscript = current_line.lastIndexOf("_", position.ch);
                if (last_subscript != -1 && last_subscript > last_math) {
                  const letter_after_subscript = editor.getRange(
                    { line: position.line, ch: last_subscript + 1 },
                    { line: position.line, ch: last_subscript + 2 },
                  );
                  if (
                    letter_after_subscript != "{" &&
                    position.ch - last_subscript <= 10
                  ) {
                    editor.replaceRange("}", position);
                    editor.replaceRange("{", {
                      line: position.line,
                      ch: last_subscript + 1,
                    });
                    event.preventDefault();
                    return;
                  }
                }
              }
              // retrieve the last unbracketed superscript
              let last_superscript = current_line.lastIndexOf("^", position.ch);
              while (last_superscript != -1) {
                const two_letters_after_superscript = editor.getRange(
                  { line: position.line, ch: last_superscript + 1 },
                  { line: position.line, ch: last_superscript + 3 },
                );
                if (
                  two_letters_after_superscript[0] == "{" ||
                  two_letters_after_superscript == " {"
                ) {
                  last_superscript = current_line.lastIndexOf(
                    "^",
                    last_superscript - 1,
                  );
                } else if (last_superscript < last_math) {
                  last_superscript = -1;
                  break;
                } else {
                  break;
                }
              }
              // retrieve the last divide symbol
              let last_divide = current_line.lastIndexOf("/", position.ch - 2);
              while (last_divide != -1) {
                const around_divide = editor.getRange(
                  { line: position.line, ch: last_divide - 1 },
                  { line: position.line, ch: last_divide + 2 },
                );
                if (around_divide[0] == " " && around_divide[2] == " ") {
                  last_divide = current_line.lastIndexOf("^", last_divide - 1);
                } else if (last_divide < last_math) {
                  last_divide = -1;
                  break;
                } else {
                  break;
                }
              }
              // perform autoEncloseSup
              if (this.settings.autoEncloseSup_toggle) {
                if (last_superscript > last_divide) {
                  // if any brackets from last sup to cursor still unclosed, dont do autoEncloseSup yet
                  const brackets = [
                    ["(", ")"],
                    ["{", "}"],
                    ["[", "]"],
                  ];
                  if (
                    !brackets.some(
                      (e) =>
                        this.unclosed_bracket(
                          editor,
                          e[0],
                          e[1],
                          position.ch,
                          last_superscript,
                        )[0],
                    )
                  ) {
                    this.autoEncloseSup(editor, event, last_superscript);
                    return;
                  }
                }
              }
              // perform autoFraction
              if (
                this.settings.autoFraction_toggle &&
                !this.withinText(editor, last_divide)
              ) {
                if (last_divide > last_dollar) {
                  const brackets = [
                    ["(", ")"],
                    ["{", "}"],
                    ["[", "]"],
                  ];
                  // if any brackets in denominator still unclosed, dont do autoFraction yet
                  if (
                    !brackets.some(
                      (e) =>
                        this.unclosed_bracket(
                          editor,
                          e[0],
                          e[1],
                          position.ch,
                          last_divide,
                        )[0],
                    )
                  ) {
                    this.autoFraction(editor, event, last_superscript);
                    return;
                  }
                }
              }
              // perform autoLargeBracket
              if (this.settings.autoLargeBracket_toggle) {
                let symbol_before = editor.getRange(
                  { line: position.line, ch: position.ch - 1 },
                  { line: position.line, ch: position.ch },
                );
                if (symbol_before == ")" || symbol_before == "]") {
                  this.autoLargeBracket(editor, event);
                  return;
                }
              }
            }
            break;
          case "Enter":
            // perform Enter shortcut within matrix block
            if (this.settings.addMatrixBlock_toggle) {
              const begin_matrix = [
                "\\begin{" + this.settings.addMatrixBlock_parameter,
                "\\begin{matrix}",
                "\\begin{bmatrix}",
                "\\begin{Bmatrix}",
                "\\begin{vmatrix}",
                "\\begin{Vmatrix}",
                "\\begin{smallmatrix}",
              ];
              const end_matrix = [
                "\\end{" + this.settings.addMatrixBlock_parameter,
                "\\end{matrix}",
                "\\end{bmatrix}",
                "\\end{Bmatrix}",
                "\\end{vmatrix}",
                "\\end{Vmatrix}",
                "\\end{smallmatrix}",
              ];
              let state = false;
              for (let i = 0; i < begin_matrix.length; i++) {
                if (
                  this.withinAnyBrackets_document(
                    editor,
                    begin_matrix[i],
                    end_matrix[i],
                  )
                ) {
                  state = true;
                  break;
                }
              }
              if (!event.shiftKey) {
                if (state) {
                  editor.replaceSelection(" \\\\ ");
                  event.preventDefault();
                  return;
                }
              }
            }
            // perform Enter shortcut within align block
            if (this.settings.addAlignBlock_toggle) {
              if (
                this.withinAnyBrackets_document(
                  editor,
                  "\\begin{" + this.settings.addAlignBlock_parameter,
                  "\\end{" + this.settings.addAlignBlock_parameter,
                )
              ) {
                if (!event.shiftKey) {
                  editor.replaceSelection("\\\\\n&");
                  event.preventDefault();
                }
                return;
              }
            }
            // enter for cases block
            if (this.settings.addCasesBlock_toggle) {
              if (
                this.withinAnyBrackets_document(
                  editor,
                  "\\begin{cases}",
                  "\\end{cases}",
                )
              ) {
                editor.replaceSelection(" \\\\\n");
                event.preventDefault();
                return;
              }
            }
            // double enter for $$
            if (this.withinMath(editor)) {
              const position = editor.getCursor();
              const prev2_Char = editor.getRange(
                { line: position.line, ch: position.ch - 2 },
                { line: position.line, ch: position.ch },
              );
              const next2_Char = editor.getRange(
                { line: position.line, ch: position.ch },
                { line: position.line, ch: position.ch + 2 },
              );
              if (prev2_Char == "$$" && next2_Char == "$$") {
                editor.replaceSelection("\n");
                editor.setCursor(position);
              }
            }
            return;
          case "Tab":
            // perform Tab shortcut within matrix block
            if (this.settings.addMatrixBlock_toggle) {
              const begin_matrix = [
                "\\begin{" + this.settings.addMatrixBlock_parameter,
                "\\begin{matrix}",
                "\\begin{bmatrix}",
                "\\begin{Bmatrix}",
                "\\begin{vmatrix}",
                "\\begin{Vmatrix}",
                "\\begin{smallmatrix}",
              ];
              const end_matrix = [
                "\\end{" + this.settings.addMatrixBlock_parameter,
                "\\end{matrix}",
                "\\end{bmatrix}",
                "\\end{Bmatrix}",
                "\\end{vmatrix}",
                "\\end{Vmatrix}",
                "\\end{smallmatrix}",
              ];
              let state = false;
              for (let i = 0; i < begin_matrix.length; i++) {
                if (
                  this.withinAnyBrackets_document(
                    editor,
                    begin_matrix[i],
                    end_matrix[i],
                  )
                ) {
                  state = true;
                  break;
                }
              }
              if (state) {
                editor.replaceSelection(" & ");
                event.preventDefault();
                return;
              }
            }
            // Tab shortcut for cases block
            if (this.settings.addCasesBlock_toggle) {
              if (
                this.withinAnyBrackets_document(
                  editor,
                  "\\begin{cases}",
                  "\\end{cases}",
                )
              ) {
                editor.replaceSelection(" & ");
                event.preventDefault();
                return;
              }
            }
            // Tab to go to next #tab with numbering or without numbering if there are no #tabs with numbers
            const position = editor.getCursor();
            const current_line = editor.getLine(position.line);
            const indexed_tab_expr = /#tab(\d+)?/g;
            let next_match;
            let current_match;
            while (
              (current_match = indexed_tab_expr.exec(current_line)) != null
            ) {
              if (
                !next_match ||
                parseInt(current_match[1]) < parseInt(next_match[1])
              )
                next_match = current_match;
            }
            if (next_match) {
              const tab_position = next_match.index;
              editor.replaceRange(
                "",
                { line: position.line, ch: tab_position },
                {
                  line: position.line,
                  ch: tab_position + next_match[0].length,
                },
              );
              editor.setCursor({ line: position.line, ch: tab_position });
              event.preventDefault();
              return;
            }
            // Tab to next close bracket
            if (this.withinMath(editor)) {
              const position = editor.getCursor();
              const current_line = editor.getLine(position.line);
              if (event.shiftKey) {
                const close_symbols = ["}", "]", ")"];
                const preceding_text = editor.getRange(
                  { line: position.line, ch: 0 },
                  { line: position.line, ch: position.ch },
                );
                for (let i = preceding_text.length; i >= 0; i--) {
                  if (close_symbols.contains(preceding_text[i])) {
                    editor.setCursor({ line: position.line, ch: i });
                    event.preventDefault();
                    return;
                  } else if (position.ch - i > 1 && preceding_text[i] == "$") {
                    editor.setCursor({ line: position.line, ch: i + 1 });
                    event.preventDefault();
                    return;
                  } else if (preceding_text.slice(-2) == "$$") {
                    editor.setCursor({
                      line: position.line,
                      ch: position.ch - 2,
                    });
                    event.preventDefault();
                    return;
                  } else if (preceding_text[-1] == "$") {
                    editor.setCursor({
                      line: position.line,
                      ch: position.ch - 1,
                    });
                    event.preventDefault();
                    return;
                  }
                }
              } else {
                const close_symbols = ["}", "]", ")", "$"];
                const following_text = editor.getRange(
                  { line: position.line, ch: position.ch + 1 },
                  { line: position.line, ch: current_line.length },
                );
                for (let i = 0; i < following_text.length; i++) {
                  if (close_symbols.contains(following_text[i])) {
                    editor.setCursor({
                      line: position.line,
                      ch: position.ch + i + 1,
                    });
                    event.preventDefault();
                    return;
                  }
                }
              }
            }
            // Tab out of $
            if (this.withinMath(editor)) {
              const position = editor.getCursor();
              const next_2 = editor.getRange(
                { line: position.line, ch: position.ch },
                { line: position.line, ch: position.ch + 2 },
              );
              if (next_2 == "$$") {
                editor.setCursor({ line: position.line, ch: position.ch + 2 });
                event.preventDefault();
                return;
              } else if (next_2[0] == "$") {
                editor.setCursor({ line: position.line, ch: position.ch + 1 });
                event.preventDefault();
                return;
              }
            }
        }
      }
    };
    this.handleKeyPress = (cm, event) => {
      if (["{", "[", "(", "m"].contains(event.key)) {
        const view = this.app.workspace.getActiveViewOfType(
          obsidian.MarkdownView,
        );
        if (!view) return;
        const editor = view.editor;
        if (this.withinMath(editor)) {
          const position = editor.getCursor();
          const brackets = [
            ["(", ")"],
            ["{", "}"],
            ["[", "]"],
          ];
          const next_char = editor.getRange(
            { line: position.line, ch: position.ch },
            { line: position.line, ch: position.ch + 1 },
          );
          const next_2char = editor.getRange(
            { line: position.line, ch: position.ch },
            { line: position.line, ch: position.ch + 2 },
          );
          const followed_by_$spacetabnonedoubleslash =
            ["$", " ", "	", ""].contains(next_char) || next_2char == "\\\\";
          switch (event.key) {
            case "{":
              if (this.settings.autoCloseCurly_toggle) {
                if (
                  !this.withinAnyBrackets_inline(editor, brackets) &&
                  followed_by_$spacetabnonedoubleslash
                ) {
                  editor.replaceSelection("{}");
                  editor.setCursor({
                    line: position.line,
                    ch: position.ch + 1,
                  });
                  event.preventDefault();
                  return;
                }
              }
              return;
            case "[":
              if (this.settings.autoCloseSquare_toggle) {
                if (
                  !this.withinAnyBrackets_inline(editor, brackets) &&
                  followed_by_$spacetabnonedoubleslash
                ) {
                  editor.replaceSelection("[]");
                  editor.setCursor({
                    line: position.line,
                    ch: position.ch + 1,
                  });
                  event.preventDefault();
                  return;
                }
              }
              return;
            case "(":
              if (this.settings.autoCloseRound_toggle) {
                if (
                  !this.withinAnyBrackets_inline(editor, brackets) &&
                  followed_by_$spacetabnonedoubleslash
                ) {
                  editor.replaceSelection("()");
                  editor.setCursor({
                    line: position.line,
                    ch: position.ch + 1,
                  });
                  event.preventDefault();
                  return;
                }
              }
              return;
            case "m":
              if (!this.settings.autoSumLimit_toggle) return;
              if (
                editor.getRange(
                  { line: position.line, ch: position.ch - 3 },
                  { line: position.line, ch: position.ch },
                ) == "\\su"
              ) {
                editor.replaceSelection("m\\limits");
                event.preventDefault();
                return;
              }
          }
        }
      }
    };
    //main functions
    this.customShorthand = (editor, position) => {
      let keyword = "";
      let keyword_length = 0;
      for (let i = 0; i < this.shorthand_array.length; i++) {
        keyword_length = this.shorthand_array[i][0].length;
        if (keyword_length > position.ch) {
          continue;
        } else if (keyword_length == position.ch) {
          keyword =
            "@" +
            editor.getRange(
              { line: position.line, ch: position.ch - keyword_length },
              { line: position.line, ch: position.ch },
            );
        } else {
          keyword = editor.getRange(
            { line: position.line, ch: position.ch - keyword_length - 1 },
            { line: position.line, ch: position.ch },
          );
        }
        if (
          keyword[0].toLowerCase() == keyword[0].toUpperCase() ||
          keyword[0] == "@"
        ) {
          if (
            this.shorthand_array[i][0] == keyword.slice(-keyword_length) &&
            this.shorthand_array[i][1] != keyword
          ) {
            const replace_slash =
              keyword[0] == "\\" && this.shorthand_array[i][1][0] == "\\"
                ? 1
                : 0;
            const set_cursor_position =
              this.shorthand_array[i][1].indexOf("#cursor");
            editor.replaceRange(
              this.shorthand_array[i][1],
              {
                line: position.line,
                ch: position.ch - keyword_length - replace_slash,
              },
              { line: position.line, ch: position.ch },
            );
            if (set_cursor_position != -1) {
              editor.replaceRange(
                "",
                {
                  line: position.line,
                  ch:
                    position.ch -
                    keyword_length -
                    replace_slash +
                    set_cursor_position,
                },
                {
                  line: position.line,
                  ch:
                    position.ch -
                    keyword_length -
                    replace_slash +
                    set_cursor_position +
                    7,
                },
              );
              editor.setCursor({
                line: position.line,
                ch:
                  position.ch -
                  keyword_length -
                  replace_slash +
                  set_cursor_position,
              });
            } else if (this.shorthand_array[i][1].slice(-2) == "{}") {
              editor.setCursor({
                line: position.line,
                ch:
                  position.ch +
                  this.shorthand_array[i][1].length -
                  keyword_length -
                  1 -
                  replace_slash,
              });
            } else;
            return true;
          }
        }
      }
    };
    this.autoEncloseSup = (editor, event, last_superscript) => {
      // superscript bracketing
      const position = editor.getCursor();
      const letter_before_cursor = editor.getRange(
        { line: position.line, ch: position.ch - 1 },
        { line: position.line, ch: position.ch },
      );
      if (last_superscript != -1 && letter_before_cursor != "^") {
        const letter_after_superscript = editor.getRange(
          { line: position.line, ch: last_superscript + 1 },
          { line: position.line, ch: last_superscript + 2 },
        );
        if (
          letter_after_superscript == "(" &&
          letter_before_cursor == ")" &&
          position.ch - last_superscript > 6
        ) {
          editor.replaceRange(
            "}",
            { line: position.line, ch: position.ch - 1 },
            { line: position.line, ch: position.ch },
          );
          editor.replaceRange(
            "{",
            { line: position.line, ch: last_superscript + 1 },
            { line: position.line, ch: last_superscript + 2 },
          );
          event.preventDefault();
          return true;
        } else if (letter_after_superscript == " ") {
          editor.replaceSelection("}");
          editor.replaceRange("{", {
            line: position.line,
            ch: last_superscript + 2,
          });
          event.preventDefault();
          return true;
        } else {
          editor.replaceSelection("}");
          editor.replaceRange("{", {
            line: position.line,
            ch: last_superscript + 1,
          });
          event.preventDefault();
          return true;
        }
      } else {
        return false;
      }
    };
    this.autoFraction = (editor, event, last_superscript) => {
      const position = editor.getCursor();
      const current_line = editor.getLine(position.line);
      let last_divide = current_line.lastIndexOf("/", position.ch - 1);
      // if cursor is preceeded by a close bracket, and the corresponding open bracket
      // is found before "/", remove the brackets and enclose whole expression using \frac
      const letter_before_cursor = editor.getRange(
        { line: position.line, ch: position.ch - 1 },
        { line: position.line, ch: position.ch },
      );
      // if there are any brackets unclosed before divide symbol,
      // include the open brackets into stop_symbols
      const brackets = [
        ["(", ")"],
        ["{", "}"],
        ["[", "]"],
      ];
      let stop_brackets = [];
      for (let i = 0; i < brackets.length; i++) {
        if (letter_before_cursor == brackets[i][1]) {
          const open_brackets = this.unclosed_bracket(
            editor,
            brackets[i][0],
            brackets[i][1],
            position.ch - 1,
            0,
          )[1];
          const pos_of_the_open_bracket =
            open_brackets[open_brackets.length - 1];
          if (pos_of_the_open_bracket < last_divide) {
            editor.replaceRange(
              "}",
              { line: position.line, ch: position.ch - 1 },
              { line: position.line, ch: position.ch },
            );
            editor.replaceRange(
              "}{",
              { line: position.line, ch: last_divide },
              { line: position.line, ch: last_divide + 1 },
            );
            editor.replaceRange(
              "\\frac{",
              { line: position.line, ch: pos_of_the_open_bracket },
              { line: position.line, ch: pos_of_the_open_bracket + 1 },
            );
            event.preventDefault();
            return;
          }
        }
        stop_brackets.push(
          ...this.unclosed_bracket(
            editor,
            brackets[i][0],
            brackets[i][1],
            last_divide,
            0,
          )[1],
        );
      }
      let frac = 0;
      // if numerator is enclosed by (), place frac in front of () and remove ()
      let numerator_remove_bracket = 0;
      if (
        editor.getRange(
          { line: position.line, ch: last_divide - 1 },
          { line: position.line, ch: last_divide },
        ) == ")"
      ) {
        const numerator_open_bracket = this.unclosed_bracket(
          editor,
          "(",
          ")",
          last_divide - 1,
          0,
        )[1].slice(-1)[0];
        frac = numerator_open_bracket - 1;
        numerator_remove_bracket = 1;
      } else {
        const stop_symbols = ["$", "=", ">", "<", ",", "/", " "];
        const symbol_positions = stop_symbols.map((e) =>
          current_line.lastIndexOf(e, last_divide - 1),
        );
        frac = Math.max(
          last_superscript,
          ...symbol_positions,
          ...stop_brackets,
        );
      }
      // if denominator is enclosed by (), remove ()
      const denominator = editor.getRange(
        { line: position.line, ch: last_divide + 1 },
        { line: position.line, ch: position.ch },
      );
      let denominator_remove_bracket = 0;
      if (denominator.slice(-1)[0] == ")") {
        const denominator_open_bracket = this.unclosed_bracket(
          editor,
          "(",
          ")",
          position.ch - 1,
          0,
        )[1].slice(-1)[0];
        if (denominator_open_bracket == last_divide + 1) {
          denominator_remove_bracket = 1;
        }
      }
      // perform \frac replace
      editor.replaceRange(
        "}",
        { line: position.line, ch: position.ch - denominator_remove_bracket },
        { line: position.line, ch: position.ch },
      );
      editor.replaceRange(
        "}{",
        { line: position.line, ch: last_divide - numerator_remove_bracket },
        {
          line: position.line,
          ch: last_divide + 1 + denominator_remove_bracket,
        },
      );
      editor.replaceRange(
        "\\frac{",
        { line: position.line, ch: frac + 1 },
        { line: position.line, ch: frac + 1 + numerator_remove_bracket },
      );
      event.preventDefault();
      return;
    };
    this.autoFractionCM6 = (editor, last_superscript) => {
      const position = editor.getCursor();
      const current_line = editor.getLine(position.line);
      let last_divide = current_line.lastIndexOf("/", position.ch - 1);
      // if cursor is preceeded by a close bracket, and the corresponding open bracket
      // is found before "/", remove the brackets and enclose whole expression using \frac
      const letter_before_cursor = editor.getRange(
        { line: position.line, ch: position.ch - 1 },
        { line: position.line, ch: position.ch },
      );
      // if there are any brackets unclosed before divide symbol,
      // include the open brackets into stop_symbols
      const brackets = [
        ["(", ")"],
        ["{", "}"],
        ["[", "]"],
      ];
      let stop_brackets = [];
      for (let i = 0; i < brackets.length; i++) {
        if (letter_before_cursor == brackets[i][1]) {
          const open_brackets = this.unclosed_bracket(
            editor,
            brackets[i][0],
            brackets[i][1],
            position.ch - 1,
            0,
          )[1];
          const pos_of_the_open_bracket =
            open_brackets[open_brackets.length - 1];
          if (pos_of_the_open_bracket < last_divide) {
            editor.replaceRange(
              "}",
              { line: position.line, ch: position.ch - 1 },
              { line: position.line, ch: position.ch },
            );
            editor.replaceRange(
              "}{",
              { line: position.line, ch: last_divide },
              { line: position.line, ch: last_divide + 1 },
            );
            editor.replaceRange(
              "\\frac{",
              { line: position.line, ch: pos_of_the_open_bracket },
              { line: position.line, ch: pos_of_the_open_bracket + 1 },
            );
            return true;
          }
        }
        stop_brackets.push(
          ...this.unclosed_bracket(
            editor,
            brackets[i][0],
            brackets[i][1],
            last_divide,
            0,
          )[1],
        );
      }
      let frac = 0;
      // if numerator is enclosed by (), place frac in front of () and remove ()
      let numerator_remove_bracket = 0;
      if (
        editor.getRange(
          { line: position.line, ch: last_divide - 1 },
          { line: position.line, ch: last_divide },
        ) == ")"
      ) {
        const numerator_open_bracket = this.unclosed_bracket(
          editor,
          "(",
          ")",
          last_divide - 1,
          0,
        )[1].slice(-1)[0];
        frac = numerator_open_bracket - 1;
        numerator_remove_bracket = 1;
      } else {
        const stop_symbols = ["$", "=", ">", "<", ",", "/", " "];
        const symbol_positions = stop_symbols.map((e) =>
          current_line.lastIndexOf(e, last_divide - 1),
        );
        frac = Math.max(
          last_superscript,
          ...symbol_positions,
          ...stop_brackets,
        );
      }
      // if denominator is enclosed by (), remove ()
      const denominator = editor.getRange(
        { line: position.line, ch: last_divide + 1 },
        { line: position.line, ch: position.ch },
      );
      let denominator_remove_bracket = 0;
      if (denominator.slice(-1)[0] == ")") {
        const denominator_open_bracket = this.unclosed_bracket(
          editor,
          "(",
          ")",
          position.ch - 1,
          0,
        )[1].slice(-1)[0];
        if (denominator_open_bracket == last_divide + 1) {
          denominator_remove_bracket = 1;
        }
      }
      // perform \frac replace
      editor.replaceRange(
        "}",
        { line: position.line, ch: position.ch - denominator_remove_bracket },
        { line: position.line, ch: position.ch },
      );
      editor.replaceRange(
        "}{",
        { line: position.line, ch: last_divide - numerator_remove_bracket },
        {
          line: position.line,
          ch: last_divide + 1 + denominator_remove_bracket,
        },
      );
      editor.replaceRange(
        "\\frac{",
        { line: position.line, ch: frac + 1 },
        { line: position.line, ch: frac + 1 + numerator_remove_bracket },
      );
      const pos = editor.getCursor();
      editor.setCursor({
        line: pos.line,
        ch: pos.ch + 1 - denominator_remove_bracket,
      });
      return true;
    };
    this.autoLargeBracket = (editor, event) => {
      const position = editor.getCursor();
      let brackets = [
        ["[", "]"],
        ["(", ")"],
      ];
      const prev_char = editor.getRange(
        { line: position.line, ch: position.ch - 1 },
        { line: position.line, ch: position.ch },
      );
      const current_brackets = brackets.filter((e) => e[1] == prev_char)[0];
      if (current_brackets.length == 0) return;
      const open_bracket = this.unclosed_bracket(
        editor,
        current_brackets[0],
        current_brackets[1],
        position.ch - 1,
        0,
      )[1].slice(-1)[0];
      const text = editor.getRange(
        { line: position.line, ch: open_bracket },
        { line: position.line, ch: position.ch },
      );
      const large_operators = ["\\sum", "\\int", "\\frac", "\\dfrac"];
      let large_operators_locations = [];
      for (let i = 0; i < large_operators.length; i++) {
        let found = 0;
        while (found != -1) {
          found = text.indexOf(large_operators[i], found + 1);
          if (found != -1) {
            large_operators_locations.push(found + open_bracket);
          }
        }
      }
      const current_line = editor.getLine(position.line);
      let retVal = false;
      for (let i = 0; i < large_operators_locations.length; i++) {
        let left_array = [];
        let right_array = [];
        for (let j = 0; j < brackets.length; j++) {
          left_array.push(
            ...this.unclosed_bracket(
              editor,
              brackets[j][0],
              brackets[j][1],
              large_operators_locations[i],
              0,
            )[1],
          );
          right_array.push(
            ...this.unclosed_bracket(
              editor,
              brackets[j][0],
              brackets[j][1],
              current_line.length,
              large_operators_locations[i],
              false,
            )[1],
          );
        }
        for (let k = right_array.length - 1; k > -1; k--) {
          // check if unclosed brackets already appended with \right
          let check_right = editor.getRange(
            { line: position.line, ch: right_array[k] - 6 },
            { line: position.line, ch: right_array[k] },
          );
          if (check_right != "\\right") {
            editor.replaceRange("\\right", {
              line: position.line,
              ch: right_array[k],
            });
            event.preventDefault();
            retVal = true;
          }
        }
        for (let l = left_array.length - 1; l > -1; l--) {
          // check if unclosed brackets already appended with \left
          let check_left = editor.getRange(
            { line: position.line, ch: left_array[l] - 5 },
            { line: position.line, ch: left_array[l] },
          );
          if (check_left != "\\left") {
            editor.replaceRange("\\left", {
              line: position.line,
              ch: left_array[l],
            });
            event.preventDefault();
            retVal = true;
          }
        }
      }
      return retVal;
    };
    //utility functions
    this.unclosed_bracket = (
      editor,
      open_symbol,
      close_symbol,
      before,
      after,
      unclosed_open_symbol = true, //false for unclosed_close_symbol
    ) => {
      // determine if there are unclosed bracket within the range specified by before and after
      const position = editor.getCursor();
      const text = editor.getRange(
        { line: position.line, ch: after },
        { line: position.line, ch: before },
      );
      let open_array = [];
      let close_array = [];
      for (let i = 0; i < text.length; i++) {
        switch (text[i]) {
          case open_symbol:
            open_array.push(after + i);
            break;
          case close_symbol:
            if (open_array.length > 0) {
              open_array.pop();
            } else {
              close_array.push(after + i);
            }
            break;
        }
      }
      if (unclosed_open_symbol) {
        return [open_array.length > 0, open_array];
      } else {
        return [close_array.length > 0, close_array];
      }
    };
    this.withinText = (editor, at_where) => {
      // check if within text{}
      const position = editor.getCursor();
      const bracket_locations = this.unclosed_bracket(
        editor,
        "{",
        "}",
        at_where,
        0,
      )[1];
      return bracket_locations.some(
        (loc) =>
          editor.getRange(
            { line: position.line, ch: loc - 4 },
            { line: position.line, ch: loc },
          ) == "text",
      );
    };
    this.withinMath = (editor) => {
      // check if cursor within $$
      const position = editor.getCursor();
      const current_line = editor.getLine(position.line);
      let cursor_index = position.ch;
      let from = 0;
      let found = current_line.indexOf("$", from);
      while (found != -1 && found < cursor_index) {
        let next_char = editor.getRange(
          { line: position.line, ch: found + 1 },
          { line: position.line, ch: found + 2 },
        );
        let prev_char = editor.getRange(
          { line: position.line, ch: found - 1 },
          { line: position.line, ch: found },
        );
        if (next_char == "$" || prev_char == "$" || next_char == " ") {
          from = found + 1;
          found = current_line.indexOf("$", from);
          continue;
        } else {
          from = found + 1;
          let next_found = current_line.indexOf("$", from);
          if (next_found == -1) {
            return false;
          } else if (cursor_index > found && cursor_index <= next_found) {
            return true;
          } else {
            from = next_found + 1;
            found = current_line.indexOf("$", from);
            continue;
          }
        }
      }
      const document_text = editor.getValue();
      cursor_index = editor.posToOffset(position);
      from = 0;
      found = document_text.indexOf("$$", from);
      let count = 0;
      while (found != -1 && found < cursor_index) {
        count += 1;
        from = found + 2;
        found = document_text.indexOf("$$", from);
      }
      return count % 2 == 1;
    };
    this.withinAnyBrackets_inline = (editor, brackets) => {
      const position = editor.getCursor();
      const current_line = editor.getLine(position.line);
      return brackets.some(
        (e) =>
          this.unclosed_bracket(editor, e[0], e[1], position.ch, 0)[0] &&
          this.unclosed_bracket(
            editor,
            e[0],
            e[1],
            current_line.length,
            position.ch,
            false,
          )[0],
      );
    };
    this.withinAnyBrackets_document = (editor, open_symbol, close_symbol) => {
      const document_text = editor.getValue();
      const cursorPos = editor.getCursor();
      const cursor_index = editor.posToOffset(cursorPos);
      // count open symbols
      let from = 0;
      let found = document_text.indexOf(open_symbol, from);
      let count = 0;
      while (found != -1 && found < cursor_index) {
        count += 1;
        from = found + 1;
        found = document_text.indexOf(open_symbol, from);
      }
      const open_symbol_counts = count;
      // count close symbols
      from = 0;
      found = document_text.indexOf(close_symbol, from);
      count = 0;
      while (found != -1 && found < cursor_index) {
        count += 1;
        from = found + 1;
        found = document_text.indexOf(close_symbol, from);
      }
      const close_symbol_counts = count;
      return open_symbol_counts > close_symbol_counts;
    };
  }
  onload() {
    return __awaiter(this, void 0, void 0, function* () {
      this.registerEditorExtension(this.makeExtensionThing());
      yield this.loadSettings();
      // preprocess shorthand array
      let shorthands = this.settings.customShorthand_parameter;
      while (shorthands.slice(-2) == "\n") {
        shorthands = shorthands.slice(0, -2);
      }
      if (shorthands.slice(-1) == ";") {
        shorthands = shorthands.slice(0, -1);
      }
      if (shorthands.lastIndexOf(";\n") == -1) {
        this.shorthand_array = shorthands
          .split(",")
          .map((item) => item.split(":"));
      } else if (shorthands.lastIndexOf(":::") == -1) {
        this.shorthand_array = shorthands
          .split(";\n")
          .map((item) => item.split(":"));
      } else {
        this.shorthand_array = shorthands
          .split(";\n")
          .map((item) => item.split(":::"));
      }
      // preprocess autoAlign array
      if (this.settings.autoAlignSymbols.trim() == "") {
        this.autoAlign_array = [];
      } else {
        this.autoAlign_array = this.settings.autoAlignSymbols.split(" ");
      }
      this.app.workspace.onLayoutReady(() => {
        this.registerCodeMirror((cm) => {
          cm.on("vim-mode-change", this.handleVimModeChange);
          cm.on("keydown", this.handleKeyDown);
          cm.on("keypress", this.handleKeyPress);
        });
        this.addSettingTab(new QuickLatexSettingTab(this.app, this));
        this.addCommand({
          id: "addAlignBlock",
          name: "Add Align Block",
          hotkeys: [
            {
              modifiers: ["Alt", "Shift"],
              key: "A",
            },
          ],
          editorCallback: (editor) => this.addAlignBlock(editor),
        });
        this.addCommand({
          id: "addInlineMath",
          name: "Add Inline Math",
          hotkeys: [
            {
              modifiers: ["Mod"],
              key: "M",
            },
          ],
          editorCallback: (editor) => this.addInlineMath(editor),
        });
        this.addCommand({
          id: "addBlockMath",
          name: "Add Block Math",
          hotkeys: [
            {
              modifiers: ["Mod", "Shift"],
              key: "M",
            },
          ],
          editorCallback: (editor) => this.addBlockMath(editor),
        });
        this.addCommand({
          id: "addMatrixBlock",
          name: "Add Matrix Block",
          hotkeys: [
            {
              modifiers: ["Alt", "Shift"],
              key: "M",
            },
          ],
          editorCallback: (editor) => this.addMatrixBlock(editor),
        });
        this.addCommand({
          id: "addCasesBlock",
          name: "Add Cases Block",
          hotkeys: [
            {
              modifiers: ["Alt", "Shift"],
              key: "C",
            },
          ],
          editorCallback: (editor) => this.addCasesBlock(editor),
        });
      });
    });
  }
  addInlineMath(editor) {
    if (!this.settings.useMathKeyboardShortcut_toggle) return false;
    const view = this.app.workspace.getActiveViewOfType(obsidian.MarkdownView);
    if (!view) return false;
    if (editor.getSelection().length > 0) {
      // enclose selected text
      const anchor = editor.getCursor("anchor");
      const head = editor.getCursor("head");
      editor.replaceSelection(`$${editor.getSelection()}$`);
      if (anchor.line > head.line) {
        editor.setSelection(
          { line: anchor.line, ch: anchor.ch },
          { line: head.line, ch: head.ch + 1 },
        );
      } else if (anchor.line < head.line) {
        editor.setSelection(
          { line: anchor.line, ch: anchor.ch + 1 },
          { line: head.line, ch: head.ch },
        );
      } else {
        editor.setSelection(
          { line: anchor.line, ch: anchor.ch + 1 },
          { line: head.line, ch: head.ch + 1 },
        );
      }
    } else {
      const position = editor.getCursor();
      editor.replaceSelection("$$");
      editor.setCursor({ line: position.line, ch: position.ch + 1 });
    }
    return true;
  }
  addBlockMath(editor) {
    if (!this.settings.useMathKeyboardShortcut_toggle) return false;
    const view = this.app.workspace.getActiveViewOfType(obsidian.MarkdownView);
    if (!view) return false;
    if (editor.getSelection().length > 0) {
      // enclose selected text
      const anchor = editor.getCursor("anchor");
      const head = editor.getCursor("head");
      editor.replaceSelection(`$$${editor.getSelection()}$$`);
      if (anchor.line > head.line) {
        editor.setSelection(
          { line: anchor.line, ch: anchor.ch },
          { line: head.line, ch: head.ch + 2 },
        );
      } else if (anchor.line < head.line) {
        editor.setSelection(
          { line: anchor.line, ch: anchor.ch + 2 },
          { line: head.line, ch: head.ch },
        );
      } else {
        editor.setSelection(
          { line: anchor.line, ch: anchor.ch + 2 },
          { line: head.line, ch: head.ch + 2 },
        );
      }
    } else {
      const position = editor.getCursor();
      editor.replaceSelection("$$$$");
      editor.setCursor({ line: position.line, ch: position.ch + 2 });
    }
    return true;
  }
  addAlignBlock(editor) {
    const view = this.app.workspace.getActiveViewOfType(obsidian.MarkdownView);
    if (!view) return;
    if (!this.settings.addAlignBlock_toggle) return;
    const selected_text = editor.getSelection();
    editor.replaceSelection(
      "\\begin{" +
        this.settings.addAlignBlock_parameter +
        "}\n" +
        selected_text +
        "\n\\end{" +
        this.settings.addAlignBlock_parameter +
        "}",
    );
    const position = editor.getCursor();
    editor.setCursor({
      line: position.line - 1,
      ch: editor.getLine(position.line - 1).length,
    });
  }
  addMatrixBlock(editor) {
    const view = this.app.workspace.getActiveViewOfType(obsidian.MarkdownView);
    if (!view) return;
    if (!this.settings.addMatrixBlock_toggle) return;
    editor.replaceSelection(
      "\\begin{" +
        this.settings.addMatrixBlock_parameter +
        "}" +
        "\\end{" +
        this.settings.addMatrixBlock_parameter +
        "}",
    );
    const position = editor.getCursor();
    const retract_length = (
      "\\end{" +
      this.settings.addMatrixBlock_parameter +
      "}"
    ).length;
    editor.setCursor({ line: position.line, ch: position.ch - retract_length });
  }
  addCasesBlock(editor) {
    const view = this.app.workspace.getActiveViewOfType(obsidian.MarkdownView);
    if (!view) return;
    if (!this.settings.addCasesBlock_toggle) return;
    const selected_text = editor.getSelection();
    editor.replaceSelection(
      "\\begin{cases}\n" + selected_text + "\n\\end{cases}",
    );
    const position = editor.getCursor();
    editor.setCursor({
      line: position.line - 1,
      ch: editor.getLine(position.line - 1).length,
    });
  }
  // Settings load and save
  loadSettings() {
    return __awaiter(this, void 0, void 0, function* () {
      this.settings = Object.assign(
        {},
        DEFAULT_SETTINGS,
        yield this.loadData(),
      );
    });
  }
  onunload() {
    this.app.workspace.iterateCodeMirrors((cm) => {
      cm.off("vim-mode-change", this.handleVimModeChange);
      cm.off("keydown", this.handleKeyDown);
      cm.off("keypress", this.handleKeyPress);
    });
  }
}
class QuickLatexSettingTab extends obsidian.PluginSettingTab {
  constructor(app, plugin) {
    super(app, plugin);
    this.plugin = plugin;
  }
  display() {
    const { containerEl } = this;
    containerEl.empty();
    containerEl.createEl("h2", { text: "Quick Latex for Obsidian - Settings" });
    new obsidian.Setting(containerEl)
      .setName("Autoclose $$ symbols")
      .setDesc(
        "Typing one $ symbol will automatically lose with another $ symbol " +
          '(best used with "Move cursor between $$ symbols" function',
      )
      .addToggle((toggle) =>
        toggle
          .setValue(this.plugin.settings.autoCloseMath_toggle)
          .onChange((value) =>
            __awaiter(this, void 0, void 0, function* () {
              this.plugin.settings.autoCloseMath_toggle = value;
              yield this.plugin.saveData(this.plugin.settings);
              this.display();
            }),
          ),
      );
    new obsidian.Setting(containerEl)
      .setName("Shortcut for inline and block math")
      .setDesc(
        "Enable keyboard shortcuts for inline ($...$) and block ($$...$$) math. " +
          "Default: ctrl+m (cmd+m on mac) for inline and ctrl+shift+m (cmd+shift+m on mac) for block.",
      )
      .addToggle((toggle) => {
        toggle
          .setValue(this.plugin.settings.useMathKeyboardShortcut_toggle)
          .onChange((value) =>
            __awaiter(this, void 0, void 0, function* () {
              this.plugin.settings.useMathKeyboardShortcut_toggle = value;
              yield this.plugin.saveData(this.plugin.settings);
              this.display();
            }),
          );
      });
    new obsidian.Setting(containerEl)
      .setName("Move cursor between $$ symbols")
      .setDesc(
        "Typing two consecutive $ symbols will automatically shift the cursor in between the $$ symbols",
      )
      .addToggle((toggle) =>
        toggle
          .setValue(this.plugin.settings.moveIntoMath_toggle)
          .onChange((value) =>
            __awaiter(this, void 0, void 0, function* () {
              this.plugin.settings.moveIntoMath_toggle = value;
              yield this.plugin.saveData(this.plugin.settings);
              this.display();
            }),
          ),
      );
    new obsidian.Setting(containerEl)
      .setName("Enclose selected expression with math symbol $$")
      .setDesc(
        'Select an expression and press "$" key will automatically ' +
          "enclose the expression with the math symbols.",
      )
      .addToggle((toggle) =>
        toggle
          .setValue(this.plugin.settings.encloseSelection_toggle)
          .onChange((value) =>
            __awaiter(this, void 0, void 0, function* () {
              this.plugin.settings.encloseSelection_toggle = value;
              yield this.plugin.saveData(this.plugin.settings);
              this.display();
            }),
          ),
      );
    new obsidian.Setting(containerEl)
      .setName("Autoclose {} curly brackets")
      .setDesc('Typing "{" will automatically close with "}"')
      .addToggle((toggle) =>
        toggle
          .setValue(this.plugin.settings.autoCloseCurly_toggle)
          .onChange((value) =>
            __awaiter(this, void 0, void 0, function* () {
              this.plugin.settings.autoCloseCurly_toggle = value;
              yield this.plugin.saveData(this.plugin.settings);
              this.display();
            }),
          ),
      );
    new obsidian.Setting(containerEl)
      .setName("Autoclose [] square brackets")
      .setDesc('Typing "[" will automatically close with "]"')
      .addToggle((toggle) =>
        toggle
          .setValue(this.plugin.settings.autoCloseSquare_toggle)
          .onChange((value) =>
            __awaiter(this, void 0, void 0, function* () {
              this.plugin.settings.autoCloseSquare_toggle = value;
              yield this.plugin.saveData(this.plugin.settings);
              this.display();
            }),
          ),
      );
    new obsidian.Setting(containerEl)
      .setName("Autoclose () round brackets")
      .setDesc('Typing "(" will automatically close with ")"')
      .addToggle((toggle) =>
        toggle
          .setValue(this.plugin.settings.autoCloseRound_toggle)
          .onChange((value) =>
            __awaiter(this, void 0, void 0, function* () {
              this.plugin.settings.autoCloseRound_toggle = value;
              yield this.plugin.saveData(this.plugin.settings);
              this.display();
            }),
          ),
      );
    new obsidian.Setting(containerEl)
      .setName('Auto append "\\limits" after "\\sum"')
      .setDesc(
        'Typing "\\sum" will automatically append "\\limits" to shorten the syntax' +
          " for proper display of the limits for summation symbol.",
      )
      .addToggle((toggle) =>
        toggle
          .setValue(this.plugin.settings.autoSumLimit_toggle)
          .onChange((value) =>
            __awaiter(this, void 0, void 0, function* () {
              this.plugin.settings.autoSumLimit_toggle = value;
              yield this.plugin.saveData(this.plugin.settings);
              this.display();
            }),
          ),
      );
    new obsidian.Setting(containerEl)
      .setName("Auto enlarge brackets that contains \\sum, \\int or \\frac")
      .setDesc(
        "Place cursor right after a () or [] bracketed expression that contains either " +
          "\\sum, \\int or \\frac and press the space key, the outermost brackets will be" +
          " appended with \\left and \\right in order to display larger brackets to enclose these big expressions.",
      )
      .addToggle((toggle) =>
        toggle
          .setValue(this.plugin.settings.autoLargeBracket_toggle)
          .onChange((value) =>
            __awaiter(this, void 0, void 0, function* () {
              this.plugin.settings.autoLargeBracket_toggle = value;
              yield this.plugin.saveData(this.plugin.settings);
              this.display();
            }),
          ),
      );
    new obsidian.Setting(containerEl)
      .setName("Auto enclose expression after superscipt with {}")
      .setDesc(
        'Typing expression after superscript "^" symbol follow by a "space" key ' +
          'will automatically surround the expression with "{}"',
      )
      .addToggle((toggle) =>
        toggle
          .setValue(this.plugin.settings.autoEncloseSup_toggle)
          .onChange((value) =>
            __awaiter(this, void 0, void 0, function* () {
              this.plugin.settings.autoEncloseSup_toggle = value;
              yield this.plugin.saveData(this.plugin.settings);
              this.display();
            }),
          ),
      );
    new obsidian.Setting(containerEl)
      .setName("Auto enclose expression after subscript with {}")
      .setDesc(
        'Typing expression after subscript "_" symbol follow by a "space" key ' +
          'will automatically surround the expression with "{}". ' +
          "Note: expression more than 10 characters long will be ignored.",
      )
      .addToggle((toggle) =>
        toggle
          .setValue(this.plugin.settings.autoEncloseSub_toggle)
          .onChange((value) =>
            __awaiter(this, void 0, void 0, function* () {
              this.plugin.settings.autoEncloseSub_toggle = value;
              yield this.plugin.saveData(this.plugin.settings);
              this.display();
            }),
          ),
      );
    new obsidian.Setting(containerEl)
      .setName('Type "/" instead of \\frac{}{}')
      .setDesc(
        'Use "/" symbol for quickly typing fractions. eg. type "1/2" followed by a "space" key' +
          " to transform to \\frac{1}{2}",
      )
      .addToggle((toggle) =>
        toggle
          .setValue(this.plugin.settings.autoFraction_toggle)
          .onChange((value) =>
            __awaiter(this, void 0, void 0, function* () {
              this.plugin.settings.autoFraction_toggle = value;
              yield this.plugin.saveData(this.plugin.settings);
              this.display();
            }),
          ),
      );
    new obsidian.Setting(containerEl)
      .setName("Shortcut for Align Block")
      .setDesc(
        "Use shortcut key to quickly insert \\begin{align*} \\end{align*} block. " +
          'Default: "Alt+Shift+A" (Mac: "Option+Shift+A")',
      )
      .addToggle((toggle) =>
        toggle
          .setValue(this.plugin.settings.addAlignBlock_toggle)
          .onChange((value) =>
            __awaiter(this, void 0, void 0, function* () {
              this.plugin.settings.addAlignBlock_toggle = value;
              yield this.plugin.saveData(this.plugin.settings);
              this.display();
            }),
          ),
      );
    new obsidian.Setting(containerEl)
      .setName("Align Block Parameter")
      .setDesc(
        "Set the text parameter in \\begin{parameter} and \\end{parameter}.",
      )
      .addText((text) =>
        text
          .setPlaceholder("default: align*")
          .setValue(this.plugin.settings.addAlignBlock_parameter)
          .onChange((value) =>
            __awaiter(this, void 0, void 0, function* () {
              this.plugin.settings.addAlignBlock_parameter = value;
              yield this.plugin.saveData(this.plugin.settings);
            }),
          ),
      );
    new obsidian.Setting(containerEl)
      .setName("【NEW!】Auto-align at these symbols")
      .setDesc(
        'When within the align block, the align symbol "&" will be automatically added before these symbols. (separate by spaces)',
      )
      .addText((text) =>
        text.setValue(this.plugin.settings.autoAlignSymbols).onChange((value) =>
          __awaiter(this, void 0, void 0, function* () {
            this.plugin.settings.autoAlignSymbols = value;
            if (value == "") {
              this.plugin.autoAlign_array = [];
            } else {
              this.plugin.autoAlign_array = value.split(" ");
            }
            yield this.plugin.saveData(this.plugin.settings);
          }),
        ),
      );
    new obsidian.Setting(containerEl)
      .setName("Shortcut for Cases Block")
      .setDesc(
        "Use shortcut key to quickly insert \\begin{cases} \\end{cases} block. " +
          'Default: "Alt+Shift+C" (Mac: "Option+Shift+C")',
      )
      .addToggle((toggle) =>
        toggle
          .setValue(this.plugin.settings.addCasesBlock_toggle)
          .onChange((value) =>
            __awaiter(this, void 0, void 0, function* () {
              this.plugin.settings.addCasesBlock_toggle = value;
              yield this.plugin.saveData(this.plugin.settings);
              this.display();
            }),
          ),
      );
    new obsidian.Setting(containerEl)
      .setName("Use shift-enter for line break in align and cases block")
      .setDesc(
        'For align and cases block above, pressing enter automatically adds line break symbol "\\" or "&". Switch here to use shift-enter instead.',
      )
      .addToggle((toggle) =>
        toggle
          .setValue(this.plugin.settings.shiftEnter_toggle)
          .onChange((value) =>
            __awaiter(this, void 0, void 0, function* () {
              this.plugin.settings.shiftEnter_toggle = value;
              yield this.plugin.saveData(this.plugin.settings);
              this.display();
            }),
          ),
      );
    new obsidian.Setting(containerEl)
      .setName("Shortcut for Matrix Block")
      .setDesc(
        "Use shortcut key to quickly  insert \\begin{pmatrix} \\end{pmatrix} block. " +
          'Default: "Alt+Shift+M" (Mac: "Option+Shift+M")',
      )
      .addToggle((toggle) =>
        toggle
          .setValue(this.plugin.settings.addMatrixBlock_toggle)
          .onChange((value) =>
            __awaiter(this, void 0, void 0, function* () {
              this.plugin.settings.addMatrixBlock_toggle = value;
              yield this.plugin.saveData(this.plugin.settings);
              this.display();
            }),
          ),
      );
    new obsidian.Setting(containerEl)
      .setName("Matrix Block Parameter")
      .setDesc(
        "Set the text parameter in \\begin{parameter} and \\end{parameter}.",
      )
      .addText((text) =>
        text
          .setPlaceholder("default: pmatrix")
          .setValue(this.plugin.settings.addMatrixBlock_parameter)
          .onChange((value) =>
            __awaiter(this, void 0, void 0, function* () {
              this.plugin.settings.addMatrixBlock_parameter = value;
              yield this.plugin.saveData(this.plugin.settings);
            }),
          ),
      );
    new obsidian.Setting(containerEl)
      .setName("Greek symbols math mode")
      .setDesc(
        "Automatically surround commands to insert Greek character written outside math mode with math chars. " +
          'Eg, typing \\alpha followed by space outside math mode will be replaced with "$\\alpha$"',
      )
      .addToggle((toggle) =>
        toggle
          .setValue(this.plugin.settings.autoGreekCommandMathMode_toggle)
          .onChange((value) =>
            __awaiter(this, void 0, void 0, function* () {
              this.plugin.settings.autoGreekCommandMathMode_toggle = value;
              yield this.plugin.saveData(this.plugin.settings);
              this.display();
            }),
          ),
      );
    new obsidian.Setting(containerEl)
      .setName("Custom Shorthand")
      .setDesc(
        "Use custom shorthand (can be multiple letters) for common latex strings. " +
          'Eg, typing "al" followed by "space/tab" key will replace with "\\alpha"',
      )
      .addToggle((toggle) =>
        toggle
          .setValue(this.plugin.settings.customShorthand_toggle)
          .onChange((value) =>
            __awaiter(this, void 0, void 0, function* () {
              this.plugin.settings.customShorthand_toggle = value;
              yield this.plugin.saveData(this.plugin.settings);
              this.display();
            }),
          ),
      );
    new obsidian.Setting(containerEl)
      .setName("Use Tab to complete custom shorthand")
      .setDesc("Use Tab instead of space to complete custom shorthand.")
      .addToggle((toggle) =>
        toggle
          .setValue(this.plugin.settings.useTabtoComplete_toggle)
          .onChange((value) =>
            __awaiter(this, void 0, void 0, function* () {
              this.plugin.settings.useTabtoComplete_toggle = value;
              yield this.plugin.saveData(this.plugin.settings);
              this.display();
            }),
          ),
      );
    new obsidian.Setting(containerEl)
      .setName("Custom Shorthand Parameter")
      .setDesc(
        'Separate the multi-letters shorthand and the snippet with ":::" and ' +
          'end each set of shorthand snippet pair by "---" and a newline. ' +
          'For expressions that end with "{}", the cursor will automatically be placed within the bracket. ' +
          'Alternatively, you can type "#cursor" within the snippet to set the cursor location after replacement. ' +
          'You can also include "#tab" within the snippet for use cases such as multiple {}s (e.g. \\binom{#cursor}{#tab}). ' +
          'Pressing tab key in such cases will jump the cursor to the next "#tab" keyword. ' +
          'Numbers after each "#tab" can be added to define the order in which to jump between the tabs (e.g. \\left#cursor #tab2 \\right#tab1 will first jump to #tab1 then back to #tab2). ' +
          "Shorthands now support multiline snippets too! " +
          "(try uninstall then reinstalling the plugin to see the new set of shorthands.) " +
          '【NOTE】For old users, please kindly replace ":" with ":::" in your custom shorthand parameter.',
      )
      .setClass("text-snippets-class")
      .addTextArea((text) =>
        text
          .setValue(this.plugin.settings.customShorthand_parameter)
          .onChange((value) =>
            __awaiter(this, void 0, void 0, function* () {
              this.plugin.settings.customShorthand_parameter = value;
              while (value.slice(-2) == "\n") {
                value = value.slice(0, -1);
              }
              if (value.slice(-1) == ";") {
                value = value.slice(0, -1);
              }
              if (value.lastIndexOf(";\n") == -1) {
                this.plugin.shorthand_array = value
                  .split(",")
                  .map((item) => item.split(":"));
              } else if (value.lastIndexOf(":::") == -1) {
                this.plugin.shorthand_array = value
                  .split(";\n")
                  .map((item) => item.split(":"));
              } else {
                this.plugin.shorthand_array = value
                  .split(";\n")
                  .map((item) => item.split(":::"));
              }
              yield this.plugin.saveData(this.plugin.settings);
            }),
          ),
      );
  }
}

module.exports = QuickLatexPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
