""" Test Vcon method doc """

import inspect
import vcon
import tests.test_filter_plugin_docs

introduction_template = """
<sub><sup>^This document is generated.  Do not edit directly.</sup></sub>
<!--- generated by tests/test_vcon_doc.py --->

# Vcon package API Documentation

## Introduction

The py-vcon package is available via pip.  It can be installed using:

    pip3 install py-vcon

Most of the functionality in the py-vcon package is contained in the vcon.Vcon class.
The following categories of methods are implemented on the Vcon class.

{TOC}
"""

section_template = """
## {title}

{methods}
"""

method_template = """
### {name}

**{name}**{signature}

{doc}

"""
expected_tags = [
    'serialize',
    'meta',
    'party',
    'dialog',
    'analysis',
    'attachment',
    'operation',
    'signing'
    'encrypting',
  ]

tag_titles = {
    'serialize': "serialize or deserialize from/to the given Vcon",
    'meta': "access or modify Vcon Meta Data",
    'party': "access or modify Vcon Party objects",
    'dialog': "access or modify Vcon Dialog objects",
    'analysis': "access or modify Vcon Analysis objects",
    'attachment': "access or modify Vcon Attachment objects",
    'operation': "perform operations on Vcon's",
    'signing': "sign or verify a signed Vcon",
    'encrypting': "encrypt or decript a Vcon`"
  }

def test_vcon_doc():

  method_list = inspect.getmembers(vcon.Vcon, predicate=inspect.isfunction)
  total_methods = len(method_list)
  num_tagged_methods = 0
  tagged_methods = {}
  untagged_methods = []
  tagged_method_names = []
  for method_tuple in method_list:
    method = method_tuple[1]
    name = method_tuple[0]
    tag = getattr(method, "_tag", None)
    if(tag is not None):
      if(tag not in tagged_methods):
        tagged_methods[tag] = []
      assert(len(method.__doc__) > 10)
      signature = inspect.signature(method)

      # TODO check all of the arguments have annotations
      for arg_name in list(signature.parameters):
        option_arg_type = signature.parameters[arg_name].annotation
        assert(option_arg_type is not None)
        assert(option_arg_type != "")
        # print("{}: type: {}".format(arg_name, option_arg_type))

      method_doc = tests.test_filter_plugin_docs.clean_doc_indentation(method.__doc__)
      tagged_methods[tag].append({"name": name, "method": method, "doc": method_doc, "signature": signature})
      num_tagged_methods += 1
      tagged_method_names.append(name)

    else:
      untagged_methods.append(name)

  print("got {} tagged of {} methods".format(num_tagged_methods, total_methods))
  print("untagged methods: {}".format(untagged_methods))
  print("tags: {}".format(list(tagged_methods.keys())))
  assert(total_methods - num_tagged_methods <= 12)
  # if the tags change, may need to check the layout and order
  assert(len(tagged_methods) == 9)

  TOC = ""
  readme_text = ""
  for tag, methods in tagged_methods.items():
    #print("{}:".format("Methods to " + tag_titles[tag]))
    TOC += " * Methods to " + tag_titles[tag] + "\n"
    methods_text = ""
    for method_dict in methods:
      # print("  {}".format(method_dict["name"] + str(method_dict["signature"])))
      methods_text += method_template.format(**method_dict)

      # TODO: aggregate TOC
      TOC += "   * [{}](#{})\n".format(method_dict["name"], method_dict["name"])

    readme_text += section_template.format(
        title = "Methods to " + tag_titles[tag],
        methods = methods_text
      )

  readme_text = introduction_template.format(TOC = TOC) + readme_text

  with open("vcon/README.md", "wt") as rm_handle:
    rm_handle.write(readme_text)

  #print(readme_text)
  # TODO: generate signatures and docs for methods


