from python_viem import get_chain_by_id, get_chain_by_name, get_chain_by_network
from python_viem.viem import CHAINS_BY_NETWORK, CHAINS_BY_NAME, CHAINS_BY_ID

# Lets say we only support the following chain ids
supported_chains = [
    84532, # base-sepolia
    11155111, # sepolia
]

# Frontend or UI should show the human readable names
human_reable_names = {}
for chain_id in supported_chains:
    chain = get_chain_by_id(chain_id)
    print(f"Chain ID: {chain_id}, Name: {chain['name']}")
    human_reable_names[chain_id] = chain['name']

# Example usage of the human readable names
for chain_id, name in human_reable_names.items():
    print(f"Supported Chain - ID: {chain_id}, Name: {name}")