# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: jinaembed.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import List

import betterproto


class JinaTaskType(betterproto.Enum):
    """
    Enum representing the different task types for Jina embeddings. These task
    types can be used to fine-tune the embedding generation process for
    specific downstream applications.
    """

    # Unspecified task type.  Use this if the task type is not known or not
    # relevant.
    TASK_UNSPECIFIED = 0
    # Used for embedding queries in a retrieval context.
    RETRIEVAL_QUERY = 1
    # Used for embedding passages or documents in a retrieval context.
    RETRIEVAL_PASSAGE = 2
    # Used for tasks involving text separation or segmentation.
    SEPARATION = 3
    # Used for text classification tasks.
    CLASSIFICATION = 4
    # Used for comparing the similarity of two or more texts.
    TEXT_MATCHING = 5


@dataclass
class JinaEmbedRequest(betterproto.Message):
    """Request message for generating embeddings with JinaEmbeddingsV3."""

    # A list of text strings to be embedded.  This allows for batch processing of
    # multiple texts in a single request.
    texts: List[str] = betterproto.string_field(1)
    # The task type for which the embeddings are being generated. This helps the
    # model optimize the embeddings for the specific task.
    task: "JinaTaskType" = betterproto.enum_field(2)
    # Optional.  Specifies the dimensionality to which the embeddings should be
    # truncated.  If provided, the embedding vectors will be truncated to this
    # length.  If not provided, the full embedding dimensionality will be
    # returned.
    truncate_dim: int = betterproto.int32_field(3)


@dataclass
class JinaEmbedReply(betterproto.Message):
    """Response message containing the generated embeddings."""

    # A list of JinaEmbedding objects, one for each input text in the
    # corresponding JinaEmbedRequest.  The order of embeddings in this list
    # matches the order of texts in the request.
    embeddings: List["JinaEmbedding"] = betterproto.message_field(1)


@dataclass
class JinaEmbedding(betterproto.Message):
    """Represents a single text embedding."""

    # The embedding vector, represented as a list of floating-point values.
    values: List[float] = betterproto.float_field(1)
