# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: viu-api.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import List

import betterproto
import grpclib


@dataclass
class EmbedNVEmbedV2Request(betterproto.Message):
    """Request message for the EmbedNVEmbedV2 RPC."""

    # The text string to be embedded.  This should be a single, coherent piece of
    # text (e.g., a sentence, paragraph, or document).
    text: str = betterproto.string_field(1)


@dataclass
class EmbedNVEmbedV2Response(betterproto.Message):
    """Response message for the EmbedNVEmbedV2 RPC."""

    # The generated embedding vector.  This is a list of floating-point numbers
    # representing the text in a high-dimensional space.
    embedding: List[float] = betterproto.float_field(1)


@dataclass
class EmbedBGEGemma2Request(betterproto.Message):
    """Request message for the EmbedBGEGemma2 RPC."""

    # The text string to be embedded.
    text: str = betterproto.string_field(1)


@dataclass
class EmbedBGEGemma2Response(betterproto.Message):
    """Response message for the EmbedBGEGemma2 RPC."""

    # The generated embedding vector, represented as a list of floats.
    embedding: List[float] = betterproto.float_field(1)


class ApiServiceStub(betterproto.ServiceStub):
    """
    ApiService provides a set of RPC methods for generating text embeddings
    using different underlying models.  It acts as a unified interface for
    accessing various embedding services.
    """

    async def embed_n_v_embed_v2(self, *, text: str = "") -> EmbedNVEmbedV2Response:
        """
        Embeds a single text string using the NVEmbedV2 model. Args:   request:
        An EmbedNVEmbedV2Request containing the text to embed. Returns:   An
        EmbedNVEmbedV2Response containing the generated embedding.
        """

        request = EmbedNVEmbedV2Request()
        request.text = text

        return await self._unary_unary(
            "/viuapi.ApiService/EmbedNVEmbedV2",
            request,
            EmbedNVEmbedV2Response,
        )

    async def embed_b_g_e_gemma2(self, *, text: str = "") -> EmbedBGEGemma2Response:
        """
        Embeds a single text string using the BGEGemma2 model. Args:   request:
        An EmbedBGEGemma2Request containing the text. Returns:   An
        EmbedBGEGemma2Response with the embedding.
        """

        request = EmbedBGEGemma2Request()
        request.text = text

        return await self._unary_unary(
            "/viuapi.ApiService/EmbedBGEGemma2",
            request,
            EmbedBGEGemma2Response,
        )

    async def embed_jina_embeddings_v3(self) -> JinaEmbedReply:
        """
        Embeds multiple text strings using the JinaEmbeddingsV3 model. This
        method supports batch processing of text inputs. Args:   request: A
        JinaEmbedRequest containing the texts and task type. Returns:   A
        JinaEmbedReply containing the embeddings for each input text.
        """

        request = JinaEmbedRequest()

        return await self._unary_unary(
            "/viuapi.ApiService/EmbedJinaEmbeddingsV3",
            request,
            JinaEmbedReply,
        )
