# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: viu-api.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import List

import betterproto
import grpclib


class JinaTaskType(betterproto.Enum):
    """
    Enum representing the different task types for Jina embeddings. These task
    types can be used to fine-tune the embedding generation process for
    specific downstream applications.
    """

    # Unspecified task type.  Use this if the task type is not known or not
    # relevant.
    TASK_UNSPECIFIED = 0
    # Used for embedding queries in a retrieval context.
    RETRIEVAL_QUERY = 1
    # Used for embedding passages or documents in a retrieval context.
    RETRIEVAL_PASSAGE = 2
    # Used for tasks involving text separation or segmentation.
    SEPARATION = 3
    # Used for text classification tasks.
    CLASSIFICATION = 4
    # Used for comparing the similarity of two or more texts.
    TEXT_MATCHING = 5


@dataclass
class EmbedNVEmbedV2Request(betterproto.Message):
    """Request message for the EmbedNVEmbedV2 RPC."""

    # The text string to be embedded.  This should be a single, coherent piece of
    # text (e.g., a sentence, paragraph, or document).
    text: str = betterproto.string_field(1)


@dataclass
class EmbedNVEmbedV2Response(betterproto.Message):
    """Response message for the EmbedNVEmbedV2 RPC."""

    # The generated embedding vector.  This is a list of floating-point numbers
    # representing the text in a high-dimensional space.
    embedding: List[float] = betterproto.float_field(1)


@dataclass
class EmbedBGEGemma2Request(betterproto.Message):
    """Request message for the EmbedBGEGemma2 RPC."""

    # The text string to be embedded.
    text: str = betterproto.string_field(1)


@dataclass
class EmbedBGEGemma2Response(betterproto.Message):
    """Response message for the EmbedBGEGemma2 RPC."""

    # The generated embedding vector, represented as a list of floats.
    embedding: List[float] = betterproto.float_field(1)


@dataclass
class JinaEmbedRequest(betterproto.Message):
    """Request message for generating embeddings with JinaEmbeddingsV3."""

    # A list of text strings to be embedded.  This allows for batch processing of
    # multiple texts in a single request.
    texts: List[str] = betterproto.string_field(1)
    # The task type for which the embeddings are being generated. This helps the
    # model optimize the embeddings for the specific task.
    task: "JinaTaskType" = betterproto.enum_field(2)
    # Optional.  Specifies the dimensionality to which the embeddings should be
    # truncated.  If provided, the embedding vectors will be truncated to this
    # length.  If not provided, the full embedding dimensionality will be
    # returned.
    truncate_dim: int = betterproto.int32_field(3)


@dataclass
class JinaEmbedReply(betterproto.Message):
    """Response message containing the generated embeddings."""

    # A list of JinaEmbedding objects, one for each input text in the
    # corresponding JinaEmbedRequest.  The order of embeddings in this list
    # matches the order of texts in the request.
    embeddings: List["JinaEmbedding"] = betterproto.message_field(1)


@dataclass
class JinaEmbedding(betterproto.Message):
    """Represents a single text embedding."""

    # The embedding vector, represented as a list of floating-point values.
    values: List[float] = betterproto.float_field(1)


class ApiServiceStub(betterproto.ServiceStub):
    """
    ApiService provides a set of RPC methods for generating text embeddings
    using different underlying models.  It acts as a unified interface for
    accessing various embedding services.
    """

    async def embed_n_v_embed_v2(self, *, text: str = "") -> EmbedNVEmbedV2Response:
        """
        Embeds a single text string using the NVEmbedV2 model. Args:   request:
        An EmbedNVEmbedV2Request containing the text to embed. Returns:   An
        EmbedNVEmbedV2Response containing the generated embedding.
        """

        request = EmbedNVEmbedV2Request()
        request.text = text

        return await self._unary_unary(
            "/viuapi.ApiService/EmbedNVEmbedV2",
            request,
            EmbedNVEmbedV2Response,
        )

    async def embed_b_g_e_gemma2(self, *, text: str = "") -> EmbedBGEGemma2Response:
        """
        Embeds a single text string using the BGEGemma2 model. Args:   request:
        An EmbedBGEGemma2Request containing the text. Returns:   An
        EmbedBGEGemma2Response with the embedding.
        """

        request = EmbedBGEGemma2Request()
        request.text = text

        return await self._unary_unary(
            "/viuapi.ApiService/EmbedBGEGemma2",
            request,
            EmbedBGEGemma2Response,
        )

    async def embed_jina_embeddings_v3(
        self, *, texts: List[str] = [], task: "JinaTaskType" = 0, truncate_dim: int = 0
    ) -> JinaEmbedReply:
        """
        Embeds multiple text strings using the JinaEmbeddingsV3 model. This
        method supports batch processing of text inputs. Args:   request: A
        JinaEmbedRequest containing the texts and task type. Returns:   A
        JinaEmbedReply containing the embeddings for each input text.
        """

        request = JinaEmbedRequest()
        request.texts = texts
        request.task = task
        request.truncate_dim = truncate_dim

        return await self._unary_unary(
            "/viuapi.ApiService/EmbedJinaEmbeddingsV3",
            request,
            JinaEmbedReply,
        )
