# -*- encoding: utf-8 -*-
#
# Copyright 2013 Hewlett-Packard Development Company, L.P.
# All Rights Reserved.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

"""Starter script for the Applier service."""

import logging as std_logging
import os
import sys

from oslo_config import cfg
from watcher.applier.framework.manager_applier import ApplierManager

from watcher.openstack.common._i18n import _LI
from watcher.openstack.common import log as logging


LOG = logging.getLogger(__name__)


def main():
    cfg.CONF(sys.argv[1:], project='python-watcher')
    logging.setup('python-watcher')

    LOG.info(_LI('Starting server in PID %s') % os.getpid())
    LOG.debug("Configuration:")
    cfg.CONF.log_opt_values(LOG, std_logging.DEBUG)

    server = ApplierManager()
    server.connect()
    server.join()
