# -*- encoding: utf-8 -*-
# Copyright (c) 2015 b<>com
#
# Authors: Jean-Emile DARTOIS <jean-emile.dartois@b-com.com>
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
# implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
from oslo_log import log

from watcher.decision_engine.solution.base import BaseSolution

LOG = log.getLogger(__name__)


class DefaultSolution(BaseSolution):
    def __init__(self):
        """Stores a set of actions generated by a strategy

        The DefaultSolution class store a set of actions generated by a
        strategy in order to achieve the goal.
        """
        super(DefaultSolution, self).__init__()
        self._actions = []

    def add_action(self, action_type,
                   applies_to,
                   input_parameters=None):
        # todo(jed) add https://pypi.python.org/pypi/schema
        action = {
            'action_type': action_type,
            'applies_to': applies_to,
            'input_parameters': input_parameters
        }
        self._actions.append(action)

    def __str__(self):
        return "\n".join(self._actions)

    @property
    def actions(self):
        """Get the current actions of the solution"""
        return self._actions
