# SPDX-License-Identifier: MIT
# SPDX-FileCopyrightText: 2021-2026 null8626

import re


class _Unit:
  __slots__: tuple[str, ...] = (
    'temperature',
    'velocity',
    'pressure',
    'precipitation',
    'visibility',
    'cm_divisor',
  )

  temperature: str
  velocity: str
  pressure: str
  precipitation: str
  visibility: str
  cm_divisor: float | int

  def __init__(
    self,
    temperature: str,
    velocity: str,
    pressure: str,
    precipitation: str,
    visibility: str,
    cm_divisor: float | int,
  ):
    self.temperature = temperature
    self.velocity = velocity
    self.pressure = pressure
    self.precipitation = precipitation
    self.visibility = visibility
    self.cm_divisor = cm_divisor

  def __repr__(self) -> str:
    return f'<Unit [{self.temperature}, {self.velocity}]>'


METRIC = _Unit('C', 'Kmph', '', 'MM', '', 1)
IMPERIAL = _Unit('F', 'Miles', 'Inches', 'Inches', 'Miles', 2.54)

LATLON_REGEX = re.compile(r'^Lat (\-?[\d\.]+) and Lon (\-?[\d\.]+)$')

KIND_EMOJIS = (
  '☀️',
  '⛅️',
  '☁️',
  '☁️',
  '🌫',
  '🌦',
  '🌧',
  '🌧',
  '⛈',
  '🌨',
  '❄️',
  '🌦',
  '🌧',
  '🌧',
  '🌨',
  '❄️',
  '🌩',
  '⛈',
)
WIND_DIRECTION_EMOJIS = '↑', '↖', '←', '↙', '↓', '↘', '→', '↗'
