# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# graph.py
# Copyright (C) 2014 Fracpete (fracpete at gmail dot com)

from pygraphviz.agraph import AGraph
import tempfile
from PIL import Image


def plot_dot_graph(graph, filename=None):
    """
    Plots a graph in graphviz dot notation.
    :param graph: the dot notation graph
    :param filename: the (optional) file to save the generated plot to. The extension determines the file format.
    """
    agraph = AGraph(graph)
    agraph.layout(prog='dot')
    if filename is None:
        filename = tempfile.mktemp(suffix=".png")
    agraph.draw(filename)
    image = Image.open(filename)
    image.show()
