# python-weka-wrapper

Python wrapper for the Java machine learning workbench [Weka](http://www.cs.waikato.ac.nz/~ml/weka/)
using the [javabridge](https://pypi.python.org/pypi/javabridge) library.

**Python 2.7 reaches its [end-of-life in 2020](https://pythonclock.org/), you should consider
using the [Python 3 version](https://github.com/fracpete/python-weka-wrapper3) of this library!**

Requirements:

* Python 2.7 (for Python 3 version see [here](https://github.com/fracpete/python-weka-wrapper3))
  * javabridge (>= 1.0.14)
  * matplotlib (optional)
  * pygraphviz (optional)
  * PIL (optional)
* Oracle JDK 1.8+

Uses:

* Weka (3.9.3)

## Installation

Detailed instructions and links to videos on installing the library are located
[here](http://fracpete.github.io/python-weka-wrapper/install.html).

Please note, that you need a build environment to compile some libraries from source.

## Forum

You can post questions, patches or enhancement requests in the following Google Group:

https://groups.google.com/forum/#!forum/python-weka-wrapper

## Examples
See [python-weka-wrapper-examples](https://github.com/fracpete/python-weka-wrapper-examples)
repository for example code on the various APIs. Also, check out the sphinx
documentation in the **doc** directory. You can generate HTML documentation
using the `make html` command in the **doc** directory.

Available online documentation:

* [Full documentation](http://fracpete.github.io/python-weka-wrapper/)
* Shortcuts
  * [Command-line](http://fracpete.github.io/python-weka-wrapper/commandline.html)
  * [API](http://fracpete.github.io/python-weka-wrapper/api.html)
  * [Examples](http://fracpete.github.io/python-weka-wrapper/examples.html)

