/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.knowledgeflow;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import weka.gui.GenericObjectEditor;
import weka.gui.PropertySheetPanel;
import weka.gui.knowledgeflow.StepEditorDialog;
import weka.knowledgeflow.StepManagerImpl;
import weka.knowledgeflow.steps.Step;
import weka.knowledgeflow.steps.WekaAlgorithmWrapper;

public class GOEStepEditorDialog
extends StepEditorDialog {
    private static final long serialVersionUID = -2500973437145276268L;
    protected StepManagerImpl m_manager;
    protected Step m_stepOriginal;
    protected PropertySheetPanel m_editor = new PropertySheetPanel();
    protected PropertySheetPanel m_secondaryEditor;
    protected JPanel m_editorHolder = new JPanel();
    protected JPanel m_primaryEditorHolder = new JPanel();

    @Override
    protected void setStepToEdit(Step step) {
        this.copyOriginal(step);
        this.addPrimaryEditorPanel("North");
        this.addSecondaryEditorPanel("South");
        JScrollPane scrollPane = new JScrollPane(this.m_editorHolder);
        this.add((Component)scrollPane, "Center");
        if (step.getDefaultSettings() != null) {
            this.addSettingsButton();
        }
        this.layoutEditor();
    }

    protected void copyOriginal(Step step) {
        this.m_manager = (StepManagerImpl)step.getStepManager();
        this.m_stepToEdit = step;
        try {
            this.m_stepOriginal = (Step)GenericObjectEditor.makeCopy(step);
        }
        catch (Exception ex) {
            this.showErrorDialog(ex);
        }
    }

    protected void addPrimaryEditorPanel(String borderLayoutPos) {
        String className = this.m_stepToEdit instanceof WekaAlgorithmWrapper ? ((WekaAlgorithmWrapper)this.m_stepToEdit).getWrappedAlgorithm().getClass().getName() : this.m_stepToEdit.getClass().getName();
        className = className.substring(className.lastIndexOf(46) + 1, className.length());
        this.m_primaryEditorHolder.setLayout(new BorderLayout());
        this.m_primaryEditorHolder.setBorder(BorderFactory.createTitledBorder(className + " options"));
        this.m_editor.setUseEnvironmentPropertyEditors(true);
        this.m_editor.setEnvironment(this.m_env);
        this.m_editor.setTarget(this.m_stepToEdit instanceof WekaAlgorithmWrapper ? ((WekaAlgorithmWrapper)this.m_stepToEdit).getWrappedAlgorithm() : this.m_stepToEdit);
        this.m_editorHolder.setLayout(new BorderLayout());
        if (this.m_editor.editableProperties() > 0 || this.m_editor.hasCustomizer()) {
            this.m_primaryEditorHolder.add((Component)this.m_editor, "North");
            this.m_editorHolder.add((Component)this.m_primaryEditorHolder, borderLayoutPos);
        } else {
            JPanel about = this.m_editor.getAboutPanel();
            this.m_editorHolder.add((Component)about, borderLayoutPos);
        }
    }

    protected void addSecondaryEditorPanel(String borderLayoutPos) {
        if (this.m_stepToEdit instanceof WekaAlgorithmWrapper) {
            this.m_secondaryEditor = new PropertySheetPanel(false);
            this.m_secondaryEditor.setUseEnvironmentPropertyEditors(true);
            this.m_secondaryEditor.setBorder(BorderFactory.createTitledBorder("Additional options"));
            this.m_secondaryEditor.setEnvironment(this.m_env);
            this.m_secondaryEditor.setTarget(this.m_stepToEdit);
            if (this.m_secondaryEditor.editableProperties() > 0 || this.m_secondaryEditor.hasCustomizer()) {
                JPanel p = new JPanel();
                p.setLayout(new BorderLayout());
                p.add((Component)this.m_secondaryEditor, "North");
                this.m_editorHolder.add((Component)p, borderLayoutPos);
            }
        }
    }

    @Override
    protected void cancelPressed() {
        if (this.m_stepOriginal != null && this.m_manager != null) {
            this.m_manager.setManagedStep(this.m_stepOriginal);
        }
    }

    @Override
    protected void okPressed() {
        if (this.m_editor.hasCustomizer()) {
            this.m_editor.closingOK();
        }
    }
}

