/*
 * Decompiled with CFR 0.152.
 */
package org.j_paine.formatter;

import java.io.StringReader;
import org.j_paine.formatter.FormatIOElement;
import org.j_paine.formatter.FormatInputList;
import org.j_paine.formatter.IllegalObjectOnWriteException;
import org.j_paine.formatter.InputStreamAndBuffer;
import org.j_paine.formatter.InvalidNumberOnReadException;
import org.j_paine.formatter.NumberParser;
import org.j_paine.formatter.NumberTooWideOnWriteException;
import org.j_paine.formatter.ParseException;
import org.j_paine.formatter.Parsers;
import org.j_paine.formatter.PrintfFormat;
import org.j_paine.formatter.TokenMgrError;

class FormatF
extends FormatIOElement {
    private int d;

    public FormatF(int n, int n2) {
        this.setWidth(n);
        this.d = n2;
    }

    String convertToString(Object object, int n) throws IllegalObjectOnWriteException, NumberTooWideOnWriteException {
        if (object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double) {
            String string = "%" + Integer.toString(this.getWidth()) + "." + Integer.toString(this.d) + "f";
            String string2 = new PrintfFormat(string).sprintf(object);
            if (string2.length() > this.getWidth()) {
                throw new NumberTooWideOnWriteException((Number)object, n, this.toString());
            }
            return string2;
        }
        throw new IllegalObjectOnWriteException(object, n, this.toString());
    }

    Object convertFromString(String string, FormatInputList formatInputList, InputStreamAndBuffer inputStreamAndBuffer) throws InvalidNumberOnReadException {
        NumberParser numberParser = Parsers.theParsers().number_parser;
        numberParser.ReInit(new StringReader(string));
        try {
            int n = numberParser.Float();
            Double d = new Double(string.substring(n));
            return d;
        }
        catch (ParseException parseException) {
            throw new InvalidNumberOnReadException(string, formatInputList.getPtr(), this.toString(), inputStreamAndBuffer.getLineErrorReport(), parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidNumberOnReadException(string, formatInputList.getPtr(), this.toString(), inputStreamAndBuffer.getLineErrorReport(), tokenMgrError.getMessage());
        }
    }

    public String toString() {
        return "F" + this.getWidth() + "." + this.d;
    }
}

