/*
 * Decompiled with CFR 0.152.
 */
package weka.datagenerators.clusterers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.Tag;
import weka.core.Utils;
import weka.datagenerators.ClusterDefinition;
import weka.datagenerators.ClusterGenerator;
import weka.datagenerators.clusterers.SubspaceClusterDefinition;

public class SubspaceCluster
extends ClusterGenerator {
    static final long serialVersionUID = -3454999858505621128L;
    protected Range m_booleanCols = new Range();
    protected Range m_nominalCols = new Range();
    protected ClusterDefinition[] m_Clusters = new ClusterDefinition[]{new SubspaceClusterDefinition(this)};
    protected int[] m_numValues;
    public static final int UNIFORM_RANDOM = 0;
    public static final int TOTAL_UNIFORM = 1;
    public static final int GAUSSIAN = 2;
    public static final Tag[] TAGS_CLUSTERTYPE = new Tag[]{new Tag(0, "uniform/random"), new Tag(1, "total uniform"), new Tag(2, "gaussian")};
    public static final int CONTINUOUS = 0;
    public static final int INTEGER = 1;
    public static final Tag[] TAGS_CLUSTERSUBTYPE = new Tag[]{new Tag(0, "continuous"), new Tag(1, "integer")};

    public String globalInfo() {
        return "A data generator that produces data points in hyperrectangular subspace clusters.";
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = this.enumToVector(super.listOptions());
        result.addElement(new Option("\tA cluster definition of class '" + SubspaceClusterDefinition.class.getName().replaceAll(".*\\.", "") + "'\n\t(definition needs to be quoted to be recognized as \n\ta single argument).", "C", 1, "-C <cluster-definition>"));
        result.addElement(new Option("", "", 0, "\nOptions specific to " + SubspaceClusterDefinition.class.getName() + ":"));
        result.addElement(new Option("\tThe indices for boolean attributes.", "b", 1, "-b <range>"));
        result.addElement(new Option("\tThe indices for nominal attributes.", "m", 1, "-m <range>"));
        result.addAll(this.enumToVector(new SubspaceClusterDefinition(this).listOptions()));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        String tmpStr = Utils.getOption('b', options);
        this.setBooleanIndices(tmpStr);
        this.m_booleanCols.setUpper(this.getNumAttributes() - 1);
        tmpStr = Utils.getOption('m', options);
        this.setNominalIndices(tmpStr);
        this.m_nominalCols.setUpper(this.getNumAttributes() - 1);
        Vector<SubspaceClusterDefinition> list = new Vector<SubspaceClusterDefinition>();
        do {
            if ((tmpStr = Utils.getOption('C', options)).length() == 0) continue;
            SubspaceClusterDefinition cl = new SubspaceClusterDefinition(this);
            cl.setOptions(Utils.splitOptions(tmpStr));
            list.add(cl);
        } while (tmpStr.length() != 0);
        this.m_Clusters = list.toArray(new ClusterDefinition[list.size()]);
    }

    public void setBooleanIndices(String rangeList) {
        this.m_booleanCols.setRanges(rangeList);
    }

    public void setBooleanCols(Range value) {
        this.m_booleanCols.setRanges(value.getRanges());
    }

    public Range getBooleanCols() {
        return this.m_booleanCols;
    }

    public String booleanColsTipText() {
        return "The range of attributes that are generated as boolean ones.";
    }

    public void setNominalIndices(String rangeList) {
        this.m_nominalCols.setRanges(rangeList);
    }

    public void setNominalCols(Range value) {
        this.m_nominalCols.setRanges(value.getRanges());
    }

    public Range getNominalCols() {
        return this.m_nominalCols;
    }

    public String nominalColsTipText() {
        return "The range of attributes to generate as nominal ones.";
    }

    protected String checkIndices() {
        for (int i = 0; i < this.getNumAttributes(); ++i) {
            if (!this.m_booleanCols.isInRange(i) || !this.m_nominalCols.isInRange(i)) continue;
            return "Error in attribute type: Attribute " + i + " is set to both boolean and nominal.";
        }
        return "";
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        Collections.addAll(result, super.getOptions());
        if (!this.getBooleanCols().toString().equalsIgnoreCase("empty")) {
            result.add("-b");
            result.add("" + this.getBooleanCols().getRanges());
        }
        if (!this.getNominalCols().toString().equalsIgnoreCase("empty")) {
            result.add("-m");
            result.add("" + this.getNominalCols().getRanges());
        }
        for (int i = 0; i < this.getClusters().length; ++i) {
            result.add("-C");
            result.add(Utils.joinOptions(this.getClusters()[i].getOptions()));
        }
        return result.toArray(new String[result.size()]);
    }

    protected ClusterDefinition[] getClusters() {
        return this.m_Clusters;
    }

    @Override
    protected int defaultNumAttributes() {
        return 1;
    }

    public ClusterDefinition[] getClusterDefinitions() {
        return this.getClusters();
    }

    public void setClusterDefinitions(ClusterDefinition[] value) throws Exception {
        String indexStr = "";
        this.m_Clusters = value;
        for (int i = 0; i < this.getClusters().length; ++i) {
            if (!(this.getClusters()[i] instanceof SubspaceClusterDefinition)) {
                if (indexStr.length() != 0) {
                    indexStr = indexStr + ",";
                }
                indexStr = indexStr + "" + (i + 1);
            }
            this.getClusters()[i].setParent(this);
        }
        if (indexStr.length() != 0) {
            throw new Exception("These cluster definitions are not '" + SubspaceClusterDefinition.class.getName() + "': " + indexStr);
        }
    }

    public String clusterDefinitionsTipText() {
        return "The clusters to use.";
    }

    protected boolean checkCoverage() {
        int i;
        int[] count = new int[this.getNumAttributes()];
        for (i = 0; i < this.getNumAttributes(); ++i) {
            if (this.m_nominalCols.isInRange(i)) {
                int n = i;
                count[n] = count[n] + 1;
            }
            if (this.m_booleanCols.isInRange(i)) {
                int n = i;
                count[n] = count[n] + 1;
            }
            for (int n = 0; n < this.getClusters().length; ++n) {
                SubspaceClusterDefinition cl = (SubspaceClusterDefinition)this.getClusters()[n];
                Range r = new Range(cl.getAttrIndexRange());
                r.setUpper(this.getNumAttributes());
                if (!r.isInRange(i)) continue;
                int n2 = i;
                count[n2] = count[n2] + 1;
            }
        }
        String attrIndex = "";
        for (i = 0; i < count.length; ++i) {
            if (count[i] != 0) continue;
            if (attrIndex.length() != 0) {
                attrIndex = attrIndex + ",";
            }
            attrIndex = attrIndex + (i + 1);
        }
        if (attrIndex.length() != 0) {
            throw new IllegalArgumentException("The following attributes are not covered by a cluster definition: " + attrIndex + "\n");
        }
        return true;
    }

    @Override
    public boolean getSingleModeFlag() {
        return false;
    }

    @Override
    public Instances defineDataFormat() throws Exception {
        this.getBooleanCols().setUpper(this.getNumAttributes());
        this.getNominalCols().setUpper(this.getNumAttributes());
        String tmpStr = this.checkIndices();
        if (tmpStr.length() > 0) {
            throw new IllegalArgumentException(tmpStr);
        }
        this.checkCoverage();
        this.m_numValues = new int[this.getNumAttributes()];
        Random random = new Random(this.getSeed());
        this.setRandom(random);
        for (int i = 0; i < this.getClusters().length; ++i) {
            SubspaceClusterDefinition cl = (SubspaceClusterDefinition)this.getClusters()[i];
            cl.setNumInstances(random);
            cl.setParent(this);
            cl.initialiseMemberVariables();
            cl.setValues();
        }
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(3);
        for (int i = 0; i < this.getNumAttributes(); ++i) {
            if (this.m_booleanCols.isInRange(i)) {
                ArrayList<String> boolValues = new ArrayList<String>(2);
                boolValues.add("false");
                boolValues.add("true");
                attributes.add(new Attribute("B" + i, boolValues));
                continue;
            }
            if (this.m_nominalCols.isInRange(i)) {
                ArrayList<String> nomValues = new ArrayList<String>(this.m_numValues[i]);
                for (int j = 0; j < this.m_numValues[i]; ++j) {
                    nomValues.add("value-" + j);
                }
                attributes.add(new Attribute("N" + i, nomValues));
                continue;
            }
            attributes.add(new Attribute("X" + i));
        }
        if (this.getClassFlag()) {
            ArrayList<String> classValues = new ArrayList<String>(this.getClusters().length);
            for (int i = 0; i < this.getClusters().length; ++i) {
                classValues.add("c" + i);
            }
            attributes.add(new Attribute("class", classValues));
        }
        Instances dataset = new Instances(this.getRelationNameToUse(), attributes, 0);
        if (this.getClassFlag()) {
            dataset.setClassIndex(this.m_NumAttributes);
        }
        this.setDatasetFormat(new Instances(dataset, 0));
        return dataset;
    }

    public boolean isBoolean(int index) {
        return this.m_booleanCols.isInRange(index);
    }

    public boolean isNominal(int index) {
        return this.m_nominalCols.isInRange(index);
    }

    public int[] getNumValues() {
        return this.m_numValues;
    }

    @Override
    public Instance generateExample() throws Exception {
        throw new Exception("Examples cannot be generated one by one.");
    }

    @Override
    public Instances generateExamples() throws Exception {
        Instances format = this.getDatasetFormat();
        Instance example = null;
        if (format == null) {
            throw new Exception("Dataset format not defined.");
        }
        block5: for (int cNum = 0; cNum < this.getClusters().length; ++cNum) {
            SubspaceClusterDefinition cl = (SubspaceClusterDefinition)this.getClusters()[cNum];
            int instNum = cl.getNumInstances();
            String cName = "c" + cNum;
            switch (cl.getClusterType().getSelectedTag().getID()) {
                case 0: {
                    for (int i = 0; i < instNum; ++i) {
                        example = this.generateExample(format, this.getRandom(), cl, cName);
                        if (example == null) continue;
                        format.add(example);
                    }
                    continue block5;
                }
                case 1: {
                    if (!cl.isInteger()) {
                        this.generateUniformExamples(format, instNum, cl, cName);
                        continue block5;
                    }
                    this.generateUniformIntegerExamples(format, instNum, cl, cName);
                    continue block5;
                }
                case 2: {
                    this.generateGaussianExamples(format, instNum, this.getRandom(), cl, cName);
                }
            }
        }
        return format;
    }

    private Instance generateExample(Instances format, Random randomG, SubspaceClusterDefinition cl, String cName) {
        boolean makeInteger = cl.isInteger();
        int num = -1;
        int numAtts = this.m_NumAttributes;
        if (this.getClassFlag()) {
            ++numAtts;
        }
        double[] values = new double[numAtts];
        boolean[] attributes = cl.getAttributes();
        double[] minValue = cl.getMinValue();
        double[] maxValue = cl.getMaxValue();
        int clusterI = -1;
        for (int i = 0; i < this.m_NumAttributes; ++i) {
            if (attributes[i]) {
                double value;
                ++clusterI;
                ++num;
                if (this.isBoolean(i) || this.isNominal(i)) {
                    if (minValue[clusterI] == maxValue[clusterI]) {
                        value = minValue[clusterI];
                    } else {
                        int numValues = (int)(maxValue[clusterI] - minValue[clusterI] + 1.0);
                        value = randomG.nextInt(numValues);
                        value += minValue[clusterI];
                    }
                } else {
                    value = randomG.nextDouble() * (maxValue[num] - minValue[num]) + minValue[num];
                    if (makeInteger) {
                        value = Math.round(value);
                    }
                }
                values[i] = value;
                continue;
            }
            values[i] = Utils.missingValue();
        }
        if (this.getClassFlag()) {
            values[format.classIndex()] = format.classAttribute().indexOfValue(cName);
        }
        DenseInstance example = new DenseInstance(1.0, values);
        example.setDataset(format);
        return example;
    }

    private void generateUniformExamples(Instances format, int numInstances, SubspaceClusterDefinition cl, String cName) {
        int numAtts = this.m_NumAttributes;
        if (this.getClassFlag()) {
            ++numAtts;
        }
        boolean[] attributes = cl.getAttributes();
        double[] minValue = cl.getMinValue();
        double[] maxValue = cl.getMaxValue();
        double[] diff = new double[minValue.length];
        for (int i = 0; i < minValue.length; ++i) {
            diff[i] = maxValue[i] - minValue[i];
        }
        int numStepsPerDimension = (int)Math.rint(Math.pow(numInstances, 1.0 / (double)minValue.length));
        int[] countPerDimension = new int[minValue.length];
        for (int j = 0; j < numInstances; ++j) {
            double[] values = new double[numAtts];
            int num = -1;
            for (int i = 0; i < this.m_NumAttributes; ++i) {
                values[i] = attributes[i] ? minValue[++num] + diff[num] * ((double)countPerDimension[num] / (double)(numStepsPerDimension - 1)) : Utils.missingValue();
            }
            if (this.getClassFlag()) {
                values[format.classIndex()] = format.classAttribute().indexOfValue(cName);
            }
            DenseInstance example = new DenseInstance(1.0, values);
            example.setDataset(format);
            format.add(example);
            countPerDimension[0] = countPerDimension[0] + 1;
            for (int i = 0; i < minValue.length; ++i) {
                if (countPerDimension[i] != numStepsPerDimension) continue;
                countPerDimension[i] = 0;
                if (i + 1 >= minValue.length) continue;
                int n = i + 1;
                countPerDimension[n] = countPerDimension[n] + 1;
            }
        }
    }

    private void generateUniformIntegerExamples(Instances format, int numInstances, SubspaceClusterDefinition cl, String cName) {
        double[] values = new double[this.getClassFlag() ? this.m_NumAttributes + 1 : this.m_NumAttributes];
        int[] minInt = new int[this.m_NumAttributes];
        int[] maxInt = new int[this.m_NumAttributes];
        int[] indices = new int[cl.getMaxValue().length];
        int num = 1;
        int index = 0;
        for (int i = 0; i < this.m_NumAttributes; ++i) {
            if (!cl.getAttributes()[i]) continue;
            minInt[i] = (int)Math.ceil(cl.getMinValue()[index]);
            maxInt[i] = (int)Math.floor(cl.getMaxValue()[index]);
            num *= maxInt[i] - minInt[i] + 1;
            indices[index++] = i;
        }
        int numEach = numInstances / num;
        int rest = numInstances - numEach * num;
        for (int i = 0; i < this.m_NumAttributes; ++i) {
            values[i] = cl.getAttributes()[i] ? (double)minInt[i] : Utils.missingValue();
        }
        if (this.getClassFlag()) {
            values[format.classIndex()] = format.classAttribute().indexOfValue(cName);
        }
        int added = 0;
        while (added < numInstances) {
            DenseInstance example = new DenseInstance(1.0, values);
            for (int k = 0; k < numEach; ++k) {
                format.add(example);
                ++added;
            }
            if (rest > 0) {
                format.add(example);
                ++added;
                --rest;
            }
            values = example.toDoubleArray();
            int n = indices[0];
            values[n] = values[n] + 1.0;
            for (int i = 0; i < indices.length; ++i) {
                if (!(values[indices[i]] > (double)maxInt[indices[i]])) continue;
                values[indices[i]] = minInt[indices[i]];
                if (i + 1 >= indices.length) continue;
                int n2 = indices[i + 1];
                values[n2] = values[n2] + 1.0;
            }
        }
    }

    private void generateGaussianExamples(Instances format, int numInstances, Random random, SubspaceClusterDefinition cl, String cName) {
        boolean makeInteger = cl.isInteger();
        int numAtts = this.m_NumAttributes;
        if (this.getClassFlag()) {
            ++numAtts;
        }
        boolean[] attributes = cl.getAttributes();
        double[] meanValue = cl.getMeanValue();
        double[] stddevValue = cl.getStddevValue();
        for (int j = 0; j < numInstances; ++j) {
            double[] values = new double[numAtts];
            int num = -1;
            for (int i = 0; i < this.m_NumAttributes; ++i) {
                if (attributes[i]) {
                    double value = meanValue[++num] + random.nextGaussian() * stddevValue[num];
                    if (makeInteger) {
                        value = Math.round(value);
                    }
                    values[i] = value;
                    continue;
                }
                values[i] = Utils.missingValue();
            }
            if (this.getClassFlag()) {
                values[format.classIndex()] = format.classAttribute().indexOfValue(cName);
            }
            DenseInstance example = new DenseInstance(1.0, values);
            example.setDataset(format);
            format.add(example);
        }
    }

    @Override
    public String generateFinished() throws Exception {
        return "";
    }

    @Override
    public String generateStart() {
        StringBuffer docu = new StringBuffer();
        int sumInst = 0;
        for (int cNum = 0; cNum < this.getClusters().length; ++cNum) {
            SubspaceClusterDefinition cl = (SubspaceClusterDefinition)this.getClusters()[cNum];
            docu.append("%\n");
            docu.append("% Cluster: c" + cNum + "   ");
            switch (cl.getClusterType().getSelectedTag().getID()) {
                case 0: {
                    docu.append("Uniform Random");
                    break;
                }
                case 1: {
                    docu.append("Total Random");
                    break;
                }
                case 2: {
                    docu.append("Gaussian");
                }
            }
            if (cl.isInteger()) {
                docu.append(" / INTEGER");
            }
            docu.append("\n% ----------------------------------------------\n");
            docu.append("%" + cl.attributesToString());
            docu.append("\n% Number of Instances:            " + cl.getInstNums() + "\n");
            docu.append("% Generated Number of Instances:  " + cl.getNumInstances() + "\n");
            sumInst += cl.getNumInstances();
        }
        docu.append("%\n% ----------------------------------------------\n");
        docu.append("% Total Number of Instances: " + sumInst + "\n");
        docu.append("%                            in " + this.getClusters().length + " Cluster(s)\n%");
        return docu.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 15706 $");
    }

    public static void main(String[] args) {
        SubspaceCluster.runDataGenerator(new SubspaceCluster(), args);
    }
}

