# This file is automatically generated from xbus/xbus.proto, DO NOT EDIT!

import asyncio
import nats.aio

import nrpc
import nrpc.exc
from nrpc import nrpc_pb2

import xbus.xbus_pb2 as xbus_dot_xbus__pb2
import nrpc.nrpc_pb2 as nrpc_dot_nrpc__pb2


PKG_SUBJECT = 'xbus.default'
PKG_SUBJECT_PARAMS = []
PKG_SUBJECT_PARAMS_COUNT = 0


Director_SUBJECT = 'director'
Director_SUBJECT_PARAMS = []
Director_SUBJECT_PARAMS_COUNT = 0


class DirectorHandler:
    methods = {
        'processingend': ('ProcessingEnd', 1, xbus_dot_xbus__pb2.ActorProcessingState, True, True, False),
        'log': ('Log', 1, xbus_dot_xbus__pb2.ActorLogRequest, True, True, False),
        'getrunningactorrequestlist': ('GetRunningActorRequestList', 1, None, True, False, True),
    }

    def __init__(self, nc, server):
        self.nc = nc
        self.server = server

    def subject(self, method='>'):
        return '.'.join([
            "xbus.default", Director_SUBJECT, method
        ])

    async def handler(self, msg):
        try:
            pkg_params, svc_params, mt_subject, tail = nrpc.parse_subject(
                PKG_SUBJECT, PKG_SUBJECT_PARAMS_COUNT,
                Director_SUBJECT, Director_SUBJECT_PARAMS_COUNT,
                msg.subject)

            mname, params_count, input_type, has_reply, void_reply, streamed_reply = self.methods[mt_subject]
            mt_params, count = nrpc.parse_subject_tail(params_count, tail)

            method = getattr(self.server, mname)
            if input_type is not None:
                req = input_type.FromString(msg.data)
                mt_params.append(req)
            err = None
            if streamed_reply:
                await nrpc.streamed_reply_handler(self.nc, msg.reply, method(*mt_params))
                return
            try:
                rep = await method(*mt_params)
            except nrpc.exc.NrpcError as e:
                err = e.as_nrpc_error()
            except Exception as e:
                err = nrpc.exc.server_error(e)
            else:
                if isinstance(rep, nrpc.ClientError):
                    err = rep
                elif void_reply and rep is not None:
                    raise ValueError(
                        "Method %s implementation should return None" % mname)
            if has_reply:
                if err is not None:
                    rawRep = b'\x00' + err.SerializeToString()
                elif rep is not None:
                    rawRep = rep.SerializeToString()
                else:
                    rawRep = b''
                await self.nc.publish(msg.reply, rawRep)
        except Exception as e:
            import traceback; traceback.print_exc()
            print("Error in Director.%s handler:" % mname, e)


class DirectorClient:
    def __init__(
        self, nc,
    ):
        self.nc = nc

    async def ProcessingEnd(
        self,
        actorID,
        req,
    ):
        subject = PKG_SUBJECT + '.' + Director_SUBJECT + '.' + 'processingend' + '.' + actorID
        rawReq = req.SerializeToString()

        rawRep = await self.nc.request(subject, rawReq, timeout=5)
        if rawRep.data and rawRep.data[0] == 0:
            raise nrpc.exc.from_error(
                nrpc_pb2.Error.FromString(rawRep.data[1:]))
        if len(rawRep.data):
            raise ValueError("Received a non-empty response")
        return None

    async def Log(
        self,
        actorID,
        req,
    ):
        subject = PKG_SUBJECT + '.' + Director_SUBJECT + '.' + 'log' + '.' + actorID
        rawReq = req.SerializeToString()

        rawRep = await self.nc.request(subject, rawReq, timeout=5)
        if rawRep.data and rawRep.data[0] == 0:
            raise nrpc.exc.from_error(
                nrpc_pb2.Error.FromString(rawRep.data[1:]))
        if len(rawRep.data):
            raise ValueError("Received a non-empty response")
        return None

    async def GetRunningActorRequestList(
        self,
        actorID,
    ):
        subject = PKG_SUBJECT + '.' + Director_SUBJECT + '.' + 'getrunningactorrequestlist' + '.' + actorID
        rawReq = b''

        async for rawRep in nrpc.streamed_reply_request(self.nc, subject, rawReq, 5):
            yield xbus_dot_xbus__pb2.ActorProcessRequest.FromString(rawRep.data)


EnvelopeStorage_SUBJECT = 'envelopestorage'
EnvelopeStorage_SUBJECT_PARAMS = []
EnvelopeStorage_SUBJECT_PARAMS_COUNT = 0


class EnvelopeStorageHandler:
    methods = {
        'retrieve': ('Retrieve', 2, xbus_dot_xbus__pb2.EnvelopePosition, True, False, True),
    }

    def __init__(self, nc, server):
        self.nc = nc
        self.server = server

    def subject(self, method='>'):
        return '.'.join([
            "xbus.default", EnvelopeStorage_SUBJECT, method
        ])

    async def handler(self, msg):
        try:
            pkg_params, svc_params, mt_subject, tail = nrpc.parse_subject(
                PKG_SUBJECT, PKG_SUBJECT_PARAMS_COUNT,
                EnvelopeStorage_SUBJECT, EnvelopeStorage_SUBJECT_PARAMS_COUNT,
                msg.subject)

            mname, params_count, input_type, has_reply, void_reply, streamed_reply = self.methods[mt_subject]
            mt_params, count = nrpc.parse_subject_tail(params_count, tail)

            method = getattr(self.server, mname)
            if input_type is not None:
                req = input_type.FromString(msg.data)
                mt_params.append(req)
            err = None
            if streamed_reply:
                await nrpc.streamed_reply_handler(self.nc, msg.reply, method(*mt_params))
                return
            try:
                rep = await method(*mt_params)
            except nrpc.exc.NrpcError as e:
                err = e.as_nrpc_error()
            except Exception as e:
                err = nrpc.exc.server_error(e)
            else:
                if isinstance(rep, nrpc.ClientError):
                    err = rep
                elif void_reply and rep is not None:
                    raise ValueError(
                        "Method %s implementation should return None" % mname)
            if has_reply:
                if err is not None:
                    rawRep = b'\x00' + err.SerializeToString()
                elif rep is not None:
                    rawRep = rep.SerializeToString()
                else:
                    rawRep = b''
                await self.nc.publish(msg.reply, rawRep)
        except Exception as e:
            import traceback; traceback.print_exc()
            print("Error in EnvelopeStorage.%s handler:" % mname, e)


class EnvelopeStorageClient:
    def __init__(
        self, nc,
    ):
        self.nc = nc

    async def Retrieve(
        self,
        clientKind,
        clientID,
        req,
    ):
        subject = PKG_SUBJECT + '.' + EnvelopeStorage_SUBJECT + '.' + 'retrieve' + '.' + clientKind + '.' + clientID
        rawReq = req.SerializeToString()

        async for rawRep in nrpc.streamed_reply_request(self.nc, subject, rawReq, 5):
            yield xbus_dot_xbus__pb2.EnvelopeFragmentAndPosition.FromString(rawRep.data)


ClientAPI_SUBJECT = 'client'
ClientAPI_SUBJECT_PARAMS = ['accountID']
ClientAPI_SUBJECT_PARAMS_COUNT = 1


class ClientAPIHandler:
    methods = {
        'getactors': ('GetActors', 0, None, True, False, False),
        'getsessiontoken': ('GetSessionToken', 0, xbus_dot_xbus__pb2.GetSessionTokenRequest, True, False, False),
    }

    def __init__(self, nc, server):
        self.nc = nc
        self.server = server

    def subject(self, svc_accountID='*', method='>'):
        return '.'.join([
            "xbus.default", ClientAPI_SUBJECT, svc_accountID, method
        ])

    async def handler(self, msg):
        try:
            pkg_params, svc_params, mt_subject, tail = nrpc.parse_subject(
                PKG_SUBJECT, PKG_SUBJECT_PARAMS_COUNT,
                ClientAPI_SUBJECT, ClientAPI_SUBJECT_PARAMS_COUNT,
                msg.subject)

            mname, params_count, input_type, has_reply, void_reply, streamed_reply = self.methods[mt_subject]
            mt_params, count = nrpc.parse_subject_tail(params_count, tail)

            method = getattr(self.server, mname)
            if input_type is not None:
                req = input_type.FromString(msg.data)
                mt_params.append(req)
            err = None
            if streamed_reply:
                await nrpc.streamed_reply_handler(self.nc, msg.reply, method(*mt_params))
                return
            try:
                rep = await method(*mt_params)
            except nrpc.exc.NrpcError as e:
                err = e.as_nrpc_error()
            except Exception as e:
                err = nrpc.exc.server_error(e)
            else:
                if isinstance(rep, nrpc.ClientError):
                    err = rep
                elif void_reply and rep is not None:
                    raise ValueError(
                        "Method %s implementation should return None" % mname)
            if has_reply:
                if err is not None:
                    rawRep = b'\x00' + err.SerializeToString()
                elif rep is not None:
                    rawRep = rep.SerializeToString()
                else:
                    rawRep = b''
                await self.nc.publish(msg.reply, rawRep)
        except Exception as e:
            import traceback; traceback.print_exc()
            print("Error in ClientAPI.%s handler:" % mname, e)


class ClientAPIClient:
    def __init__(
        self, nc,
        svc_accountID,
    ):
        self.nc = nc
        self.svc_accountID = svc_accountID

    async def GetActors(
        self,
    ):
        subject = PKG_SUBJECT + '.' + ClientAPI_SUBJECT + '.' + self.svc_accountID + '.' + 'getactors'
        rawReq = b''

        rawRep = await self.nc.request(subject, rawReq, timeout=5)
        if rawRep.data and rawRep.data[0] == 0:
            raise nrpc.exc.from_error(
                nrpc_pb2.Error.FromString(rawRep.data[1:]))
        return xbus_dot_xbus__pb2.ClientGetActorsReply.FromString(rawRep.data)

    async def GetSessionToken(
        self,
        req,
    ):
        subject = PKG_SUBJECT + '.' + ClientAPI_SUBJECT + '.' + self.svc_accountID + '.' + 'getsessiontoken'
        rawReq = req.SerializeToString()

        rawRep = await self.nc.request(subject, rawReq, timeout=5)
        if rawRep.data and rawRep.data[0] == 0:
            raise nrpc.exc.from_error(
                nrpc_pb2.Error.FromString(rawRep.data[1:]))
        return xbus_dot_xbus__pb2.SessionToken.FromString(rawRep.data)


WhoAmI_SUBJECT = 'client'
WhoAmI_SUBJECT_PARAMS = []
WhoAmI_SUBJECT_PARAMS_COUNT = 0


class WhoAmIHandler:
    methods = {
        'whoami': ('WhoAmI', 1, None, True, False, False),
    }

    def __init__(self, nc, server):
        self.nc = nc
        self.server = server

    def subject(self, method='>'):
        return '.'.join([
            "xbus.default", WhoAmI_SUBJECT, method
        ])

    async def handler(self, msg):
        try:
            pkg_params, svc_params, mt_subject, tail = nrpc.parse_subject(
                PKG_SUBJECT, PKG_SUBJECT_PARAMS_COUNT,
                WhoAmI_SUBJECT, WhoAmI_SUBJECT_PARAMS_COUNT,
                msg.subject)

            mname, params_count, input_type, has_reply, void_reply, streamed_reply = self.methods[mt_subject]
            mt_params, count = nrpc.parse_subject_tail(params_count, tail)

            method = getattr(self.server, mname)
            if input_type is not None:
                req = input_type.FromString(msg.data)
                mt_params.append(req)
            err = None
            if streamed_reply:
                await nrpc.streamed_reply_handler(self.nc, msg.reply, method(*mt_params))
                return
            try:
                rep = await method(*mt_params)
            except nrpc.exc.NrpcError as e:
                err = e.as_nrpc_error()
            except Exception as e:
                err = nrpc.exc.server_error(e)
            else:
                if isinstance(rep, nrpc.ClientError):
                    err = rep
                elif void_reply and rep is not None:
                    raise ValueError(
                        "Method %s implementation should return None" % mname)
            if has_reply:
                if err is not None:
                    rawRep = b'\x00' + err.SerializeToString()
                elif rep is not None:
                    rawRep = rep.SerializeToString()
                else:
                    rawRep = b''
                await self.nc.publish(msg.reply, rawRep)
        except Exception as e:
            import traceback; traceback.print_exc()
            print("Error in WhoAmI.%s handler:" % mname, e)


class WhoAmIClient:
    def __init__(
        self, nc,
    ):
        self.nc = nc

    async def WhoAmI(
        self,
        identifier,
    ):
        subject = PKG_SUBJECT + '.' + WhoAmI_SUBJECT + '.' + 'whoami' + '.' + identifier
        rawReq = b''

        rawRep = await self.nc.request(subject, rawReq, timeout=5)
        if rawRep.data and rawRep.data[0] == 0:
            raise nrpc.exc.from_error(
                nrpc_pb2.Error.FromString(rawRep.data[1:]))
        return xbus_dot_xbus__pb2.Account.FromString(rawRep.data)


ProcessState_SUBJECT = 'processstate'
ProcessState_SUBJECT_PARAMS = []
ProcessState_SUBJECT_PARAMS_COUNT = 0


class ProcessStateHandler:
    methods = {
        'envelopestates': ('EnvelopeStates', 2, nrpc_dot_nrpc__pb2.NoRequest, True, False, False),
        'getenvelopestate': ('GetEnvelopeState', 1, xbus_dot_xbus__pb2.GetEnvelopeStateRequest, True, False, False),
        'ackresult': ('AckResult', 1, xbus_dot_xbus__pb2.AckResultRequest, True, True, False),
        'list': ('List', 1, xbus_dot_xbus__pb2.ProcessFilter, True, False, True),
    }

    def __init__(self, nc, server):
        self.nc = nc
        self.server = server

    def subject(self, method='>'):
        return '.'.join([
            "xbus.default", ProcessState_SUBJECT, method
        ])

    async def handler(self, msg):
        try:
            pkg_params, svc_params, mt_subject, tail = nrpc.parse_subject(
                PKG_SUBJECT, PKG_SUBJECT_PARAMS_COUNT,
                ProcessState_SUBJECT, ProcessState_SUBJECT_PARAMS_COUNT,
                msg.subject)

            mname, params_count, input_type, has_reply, void_reply, streamed_reply = self.methods[mt_subject]
            mt_params, count = nrpc.parse_subject_tail(params_count, tail)

            method = getattr(self.server, mname)
            if input_type is not None:
                req = input_type.FromString(msg.data)
                mt_params.append(req)
            err = None
            if streamed_reply:
                await nrpc.streamed_reply_handler(self.nc, msg.reply, method(*mt_params))
                return
            try:
                rep = await method(*mt_params)
            except nrpc.exc.NrpcError as e:
                err = e.as_nrpc_error()
            except Exception as e:
                err = nrpc.exc.server_error(e)
            else:
                if isinstance(rep, nrpc.ClientError):
                    err = rep
                elif void_reply and rep is not None:
                    raise ValueError(
                        "Method %s implementation should return None" % mname)
            if has_reply:
                if err is not None:
                    rawRep = b'\x00' + err.SerializeToString()
                elif rep is not None:
                    rawRep = rep.SerializeToString()
                else:
                    rawRep = b''
                await self.nc.publish(msg.reply, rawRep)
        except Exception as e:
            import traceback; traceback.print_exc()
            print("Error in ProcessState.%s handler:" % mname, e)


class ProcessStateClient:
    def __init__(
        self, nc,
    ):
        self.nc = nc

    async def EnvelopeStates(
        self,
        emitterID,
        envelopeID,
        req,
    ):
        subject = PKG_SUBJECT + '.' + ProcessState_SUBJECT + '.' + 'envelopestates' + '.' + emitterID + '.' + envelopeID
        rawReq = req.SerializeToString()

        rawRep = await self.nc.request(subject, rawReq, timeout=5)
        if rawRep.data and rawRep.data[0] == 0:
            raise nrpc.exc.from_error(
                nrpc_pb2.Error.FromString(rawRep.data[1:]))
        return xbus_dot_xbus__pb2.EmitterEnvelopeState.FromString(rawRep.data)

    async def GetEnvelopeState(
        self,
        emitterID,
        req,
    ):
        subject = PKG_SUBJECT + '.' + ProcessState_SUBJECT + '.' + 'getenvelopestate' + '.' + emitterID
        rawReq = req.SerializeToString()

        rawRep = await self.nc.request(subject, rawReq, timeout=5)
        if rawRep.data and rawRep.data[0] == 0:
            raise nrpc.exc.from_error(
                nrpc_pb2.Error.FromString(rawRep.data[1:]))
        return xbus_dot_xbus__pb2.EmitterEnvelopeState.FromString(rawRep.data)

    async def AckResult(
        self,
        emitterID,
        req,
    ):
        subject = PKG_SUBJECT + '.' + ProcessState_SUBJECT + '.' + 'ackresult' + '.' + emitterID
        rawReq = req.SerializeToString()

        rawRep = await self.nc.request(subject, rawReq, timeout=5)
        if rawRep.data and rawRep.data[0] == 0:
            raise nrpc.exc.from_error(
                nrpc_pb2.Error.FromString(rawRep.data[1:]))
        if len(rawRep.data):
            raise ValueError("Received a non-empty response")
        return None

    async def List(
        self,
        emitterID,
        req,
    ):
        subject = PKG_SUBJECT + '.' + ProcessState_SUBJECT + '.' + 'list' + '.' + emitterID
        rawReq = req.SerializeToString()

        async for rawRep in nrpc.streamed_reply_request(self.nc, subject, rawReq, 5):
            yield xbus_dot_xbus__pb2.EmitterEnvelopeStateList.FromString(rawRep.data)


ActorAgent_SUBJECT = 'actoragent'
ActorAgent_SUBJECT_PARAMS = ['actorID']
ActorAgent_SUBJECT_PARAMS_COUNT = 1


class ActorAgentHandler:
    methods = {
        'process': ('Process', 0, xbus_dot_xbus__pb2.ActorProcessRequest, True, False, True),
    }

    def __init__(self, nc, server):
        self.nc = nc
        self.server = server

    def subject(self, svc_actorID='*', method='>'):
        return '.'.join([
            "xbus.default", ActorAgent_SUBJECT, svc_actorID, method
        ])

    async def handler(self, msg):
        try:
            pkg_params, svc_params, mt_subject, tail = nrpc.parse_subject(
                PKG_SUBJECT, PKG_SUBJECT_PARAMS_COUNT,
                ActorAgent_SUBJECT, ActorAgent_SUBJECT_PARAMS_COUNT,
                msg.subject)

            mname, params_count, input_type, has_reply, void_reply, streamed_reply = self.methods[mt_subject]
            mt_params, count = nrpc.parse_subject_tail(params_count, tail)

            method = getattr(self.server, mname)
            if input_type is not None:
                req = input_type.FromString(msg.data)
                mt_params.append(req)
            err = None
            if streamed_reply:
                await nrpc.streamed_reply_handler(self.nc, msg.reply, method(*mt_params))
                return
            try:
                rep = await method(*mt_params)
            except nrpc.exc.NrpcError as e:
                err = e.as_nrpc_error()
            except Exception as e:
                err = nrpc.exc.server_error(e)
            else:
                if isinstance(rep, nrpc.ClientError):
                    err = rep
                elif void_reply and rep is not None:
                    raise ValueError(
                        "Method %s implementation should return None" % mname)
            if has_reply:
                if err is not None:
                    rawRep = b'\x00' + err.SerializeToString()
                elif rep is not None:
                    rawRep = rep.SerializeToString()
                else:
                    rawRep = b''
                await self.nc.publish(msg.reply, rawRep)
        except Exception as e:
            import traceback; traceback.print_exc()
            print("Error in ActorAgent.%s handler:" % mname, e)


class ActorAgentClient:
    def __init__(
        self, nc,
        svc_actorID,
    ):
        self.nc = nc
        self.svc_actorID = svc_actorID

    async def Process(
        self,
        req,
    ):
        subject = PKG_SUBJECT + '.' + ActorAgent_SUBJECT + '.' + self.svc_actorID + '.' + 'process'
        rawReq = req.SerializeToString()

        async for rawRep in nrpc.streamed_reply_request(self.nc, subject, rawReq, 5):
            yield xbus_dot_xbus__pb2.ActorProcessingState.FromString(rawRep.data)


Broker_SUBJECT = 'broker'
Broker_SUBJECT_PARAMS = ['actorID']
Broker_SUBJECT_PARAMS_COUNT = 1


class BrokerHandler:
    methods = {
        'output': ('Output', 0, xbus_dot_xbus__pb2.OutputRequest, True, False, False),
    }

    def __init__(self, nc, server):
        self.nc = nc
        self.server = server

    def subject(self, svc_actorID='*', method='>'):
        return '.'.join([
            "xbus.default", Broker_SUBJECT, svc_actorID, method
        ])

    async def handler(self, msg):
        try:
            pkg_params, svc_params, mt_subject, tail = nrpc.parse_subject(
                PKG_SUBJECT, PKG_SUBJECT_PARAMS_COUNT,
                Broker_SUBJECT, Broker_SUBJECT_PARAMS_COUNT,
                msg.subject)

            mname, params_count, input_type, has_reply, void_reply, streamed_reply = self.methods[mt_subject]
            mt_params, count = nrpc.parse_subject_tail(params_count, tail)

            method = getattr(self.server, mname)
            if input_type is not None:
                req = input_type.FromString(msg.data)
                mt_params.append(req)
            err = None
            if streamed_reply:
                await nrpc.streamed_reply_handler(self.nc, msg.reply, method(*mt_params))
                return
            try:
                rep = await method(*mt_params)
            except nrpc.exc.NrpcError as e:
                err = e.as_nrpc_error()
            except Exception as e:
                err = nrpc.exc.server_error(e)
            else:
                if isinstance(rep, nrpc.ClientError):
                    err = rep
                elif void_reply and rep is not None:
                    raise ValueError(
                        "Method %s implementation should return None" % mname)
            if has_reply:
                if err is not None:
                    rawRep = b'\x00' + err.SerializeToString()
                elif rep is not None:
                    rawRep = rep.SerializeToString()
                else:
                    rawRep = b''
                await self.nc.publish(msg.reply, rawRep)
        except Exception as e:
            import traceback; traceback.print_exc()
            print("Error in Broker.%s handler:" % mname, e)


class BrokerClient:
    def __init__(
        self, nc,
        svc_actorID,
    ):
        self.nc = nc
        self.svc_actorID = svc_actorID

    async def Output(
        self,
        req,
    ):
        subject = PKG_SUBJECT + '.' + Broker_SUBJECT + '.' + self.svc_actorID + '.' + 'output'
        rawReq = req.SerializeToString()

        rawRep = await self.nc.request(subject, rawReq, timeout=5)
        if rawRep.data and rawRep.data[0] == 0:
            raise nrpc.exc.from_error(
                nrpc_pb2.Error.FromString(rawRep.data[1:]))
        return xbus_dot_xbus__pb2.EnvelopeAck.FromString(rawRep.data)


CoreEvents_SUBJECT = 'core.events'
CoreEvents_SUBJECT_PARAMS = []
CoreEvents_SUBJECT_PARAMS_COUNT = 0


class CoreEventsHandler:
    methods = {
        'actor': ('Actor', 0, nrpc_dot_nrpc__pb2.NoRequest, True, False, False),
        'process': ('Process', 0, nrpc_dot_nrpc__pb2.NoRequest, True, False, False),
        'processnodeready': ('ProcessNodeReady', 0, nrpc_dot_nrpc__pb2.NoRequest, True, False, False),
        'envelope': ('Envelope', 0, nrpc_dot_nrpc__pb2.NoRequest, True, False, False),
    }

    def __init__(self, nc, server):
        self.nc = nc
        self.server = server

    def subject(self, method='>'):
        return '.'.join([
            "xbus.default", CoreEvents_SUBJECT, method
        ])

    async def handler(self, msg):
        try:
            pkg_params, svc_params, mt_subject, tail = nrpc.parse_subject(
                PKG_SUBJECT, PKG_SUBJECT_PARAMS_COUNT,
                CoreEvents_SUBJECT, CoreEvents_SUBJECT_PARAMS_COUNT,
                msg.subject)

            mname, params_count, input_type, has_reply, void_reply, streamed_reply = self.methods[mt_subject]
            mt_params, count = nrpc.parse_subject_tail(params_count, tail)

            method = getattr(self.server, mname)
            if input_type is not None:
                req = input_type.FromString(msg.data)
                mt_params.append(req)
            err = None
            if streamed_reply:
                await nrpc.streamed_reply_handler(self.nc, msg.reply, method(*mt_params))
                return
            try:
                rep = await method(*mt_params)
            except nrpc.exc.NrpcError as e:
                err = e.as_nrpc_error()
            except Exception as e:
                err = nrpc.exc.server_error(e)
            else:
                if isinstance(rep, nrpc.ClientError):
                    err = rep
                elif void_reply and rep is not None:
                    raise ValueError(
                        "Method %s implementation should return None" % mname)
            if has_reply:
                if err is not None:
                    rawRep = b'\x00' + err.SerializeToString()
                elif rep is not None:
                    rawRep = rep.SerializeToString()
                else:
                    rawRep = b''
                await self.nc.publish(msg.reply, rawRep)
        except Exception as e:
            import traceback; traceback.print_exc()
            print("Error in CoreEvents.%s handler:" % mname, e)


class CoreEventsClient:
    def __init__(
        self, nc,
    ):
        self.nc = nc

    async def Actor(
        self,
        req,
    ):
        subject = PKG_SUBJECT + '.' + CoreEvents_SUBJECT + '.' + 'actor'
        rawReq = req.SerializeToString()

        rawRep = await self.nc.request(subject, rawReq, timeout=5)
        if rawRep.data and rawRep.data[0] == 0:
            raise nrpc.exc.from_error(
                nrpc_pb2.Error.FromString(rawRep.data[1:]))
        return xbus_dot_xbus__pb2.CoreEvent.FromString(rawRep.data)

    async def Process(
        self,
        req,
    ):
        subject = PKG_SUBJECT + '.' + CoreEvents_SUBJECT + '.' + 'process'
        rawReq = req.SerializeToString()

        rawRep = await self.nc.request(subject, rawReq, timeout=5)
        if rawRep.data and rawRep.data[0] == 0:
            raise nrpc.exc.from_error(
                nrpc_pb2.Error.FromString(rawRep.data[1:]))
        return xbus_dot_xbus__pb2.CoreEvent.FromString(rawRep.data)

    async def ProcessNodeReady(
        self,
        req,
    ):
        subject = PKG_SUBJECT + '.' + CoreEvents_SUBJECT + '.' + 'processnodeready'
        rawReq = req.SerializeToString()

        rawRep = await self.nc.request(subject, rawReq, timeout=5)
        if rawRep.data and rawRep.data[0] == 0:
            raise nrpc.exc.from_error(
                nrpc_pb2.Error.FromString(rawRep.data[1:]))
        return xbus_dot_xbus__pb2.ProcessNodeReadyEvent.FromString(rawRep.data)

    async def Envelope(
        self,
        req,
    ):
        subject = PKG_SUBJECT + '.' + CoreEvents_SUBJECT + '.' + 'envelope'
        rawReq = req.SerializeToString()

        rawRep = await self.nc.request(subject, rawReq, timeout=5)
        if rawRep.data and rawRep.data[0] == 0:
            raise nrpc.exc.from_error(
                nrpc_pb2.Error.FromString(rawRep.data[1:]))
        return xbus_dot_xbus__pb2.EnvelopeEvent.FromString(rawRep.data)


SvcRegistration_SUBJECT = 'registration'
SvcRegistration_SUBJECT_PARAMS = []
SvcRegistration_SUBJECT_PARAMS_COUNT = 0


class SvcRegistrationHandler:
    methods = {
        'register': ('Register', 0, xbus_dot_xbus__pb2.RegistrationRequest, True, False, False),
        'update': ('Update', 1, xbus_dot_xbus__pb2.RegistrationRequest, True, False, False),
    }

    def __init__(self, nc, server):
        self.nc = nc
        self.server = server

    def subject(self, method='>'):
        return '.'.join([
            "xbus.default", SvcRegistration_SUBJECT, method
        ])

    async def handler(self, msg):
        try:
            pkg_params, svc_params, mt_subject, tail = nrpc.parse_subject(
                PKG_SUBJECT, PKG_SUBJECT_PARAMS_COUNT,
                SvcRegistration_SUBJECT, SvcRegistration_SUBJECT_PARAMS_COUNT,
                msg.subject)

            mname, params_count, input_type, has_reply, void_reply, streamed_reply = self.methods[mt_subject]
            mt_params, count = nrpc.parse_subject_tail(params_count, tail)

            method = getattr(self.server, mname)
            if input_type is not None:
                req = input_type.FromString(msg.data)
                mt_params.append(req)
            err = None
            if streamed_reply:
                await nrpc.streamed_reply_handler(self.nc, msg.reply, method(*mt_params))
                return
            try:
                rep = await method(*mt_params)
            except nrpc.exc.NrpcError as e:
                err = e.as_nrpc_error()
            except Exception as e:
                err = nrpc.exc.server_error(e)
            else:
                if isinstance(rep, nrpc.ClientError):
                    err = rep
                elif void_reply and rep is not None:
                    raise ValueError(
                        "Method %s implementation should return None" % mname)
            if has_reply:
                if err is not None:
                    rawRep = b'\x00' + err.SerializeToString()
                elif rep is not None:
                    rawRep = rep.SerializeToString()
                else:
                    rawRep = b''
                await self.nc.publish(msg.reply, rawRep)
        except Exception as e:
            import traceback; traceback.print_exc()
            print("Error in SvcRegistration.%s handler:" % mname, e)


class SvcRegistrationClient:
    def __init__(
        self, nc,
    ):
        self.nc = nc

    async def Register(
        self,
        req,
    ):
        subject = PKG_SUBJECT + '.' + SvcRegistration_SUBJECT + '.' + 'register'
        rawReq = req.SerializeToString()

        rawRep = await self.nc.request(subject, rawReq, timeout=5)
        if rawRep.data and rawRep.data[0] == 0:
            raise nrpc.exc.from_error(
                nrpc_pb2.Error.FromString(rawRep.data[1:]))
        return xbus_dot_xbus__pb2.Registration.FromString(rawRep.data)

    async def Update(
        self,
        accountID,
        req,
    ):
        subject = PKG_SUBJECT + '.' + SvcRegistration_SUBJECT + '.' + 'update' + '.' + accountID
        rawReq = req.SerializeToString()

        rawRep = await self.nc.request(subject, rawReq, timeout=5)
        if rawRep.data and rawRep.data[0] == 0:
            raise nrpc.exc.from_error(
                nrpc_pb2.Error.FromString(rawRep.data[1:]))
        return xbus_dot_xbus__pb2.Registration.FromString(rawRep.data)


Sentinel_SUBJECT = 'sentinel'
Sentinel_SUBJECT_PARAMS = []
Sentinel_SUBJECT_PARAMS_COUNT = 0


class SentinelHandler:
    methods = {
        'survey': ('Survey', 0, nrpc_dot_nrpc__pb2.NoRequest, True, False, False),
        'actorready': ('ActorReady', 1, None, False, False, False),
        'actorleaving': ('ActorLeaving', 1, None, False, False, False),
        'listactors': ('ListActors', 0, None, True, False, True),
    }

    def __init__(self, nc, server):
        self.nc = nc
        self.server = server

    def subject(self, method='>'):
        return '.'.join([
            "xbus.default", Sentinel_SUBJECT, method
        ])

    async def handler(self, msg):
        try:
            pkg_params, svc_params, mt_subject, tail = nrpc.parse_subject(
                PKG_SUBJECT, PKG_SUBJECT_PARAMS_COUNT,
                Sentinel_SUBJECT, Sentinel_SUBJECT_PARAMS_COUNT,
                msg.subject)

            mname, params_count, input_type, has_reply, void_reply, streamed_reply = self.methods[mt_subject]
            mt_params, count = nrpc.parse_subject_tail(params_count, tail)

            method = getattr(self.server, mname)
            if input_type is not None:
                req = input_type.FromString(msg.data)
                mt_params.append(req)
            err = None
            if streamed_reply:
                await nrpc.streamed_reply_handler(self.nc, msg.reply, method(*mt_params))
                return
            try:
                rep = await method(*mt_params)
            except nrpc.exc.NrpcError as e:
                err = e.as_nrpc_error()
            except Exception as e:
                err = nrpc.exc.server_error(e)
            else:
                if isinstance(rep, nrpc.ClientError):
                    err = rep
                elif void_reply and rep is not None:
                    raise ValueError(
                        "Method %s implementation should return None" % mname)
            if has_reply:
                if err is not None:
                    rawRep = b'\x00' + err.SerializeToString()
                elif rep is not None:
                    rawRep = rep.SerializeToString()
                else:
                    rawRep = b''
                await self.nc.publish(msg.reply, rawRep)
        except Exception as e:
            import traceback; traceback.print_exc()
            print("Error in Sentinel.%s handler:" % mname, e)


class SentinelClient:
    def __init__(
        self, nc,
    ):
        self.nc = nc

    async def Survey(
        self,
        req,
    ):
        subject = PKG_SUBJECT + '.' + Sentinel_SUBJECT + '.' + 'survey'
        rawReq = req.SerializeToString()

        rawRep = await self.nc.request(subject, rawReq, timeout=5)
        if rawRep.data and rawRep.data[0] == 0:
            raise nrpc.exc.from_error(
                nrpc_pb2.Error.FromString(rawRep.data[1:]))
        return xbus_dot_xbus__pb2.SurveyRequest.FromString(rawRep.data)

    async def ActorReady(
        self,
        actorID,
    ):
        subject = PKG_SUBJECT + '.' + Sentinel_SUBJECT + '.' + 'actorready' + '.' + actorID
        rawReq = b''

        await self.nc.publish(subject, rawReq)

    async def ActorLeaving(
        self,
        actorID,
    ):
        subject = PKG_SUBJECT + '.' + Sentinel_SUBJECT + '.' + 'actorleaving' + '.' + actorID
        rawReq = b''

        await self.nc.publish(subject, rawReq)

    async def ListActors(
        self,
    ):
        subject = PKG_SUBJECT + '.' + Sentinel_SUBJECT + '.' + 'listactors'
        rawReq = b''

        async for rawRep in nrpc.streamed_reply_request(self.nc, subject, rawReq, 5):
            yield xbus_dot_xbus__pb2.ClientGetActorsReply.FromString(rawRep.data)
