# ARIMA（自己回帰和分移動平均）

ARIMAは、時系列データの予測に使用される統計モデルです。ARIMAは次の3つの主要な要素から構成されています。

1. **自己回帰（AR）コンポーネント**：この部分は時系列データの自己相関をモデル化します。これは以下の方程式で表現できます：

   $$\[X_t = c + \phi_1 X_{t-1} + \phi_2 X_{t-2} + \ldots + \phi_p X_{t-p} + \varepsilon_t\]$$

   ここで：
   - $\(X_t\)$は時刻$\(t\)$での値です。
   - $\(c\)$は定数です。
   - $\(\phi_1, \phi_2, \ldots, \phi_p\)$は自己回帰係数です。
   - $\(\varepsilon_t\)$はホワイトノイズです。

2. **積分（I）コンポーネント**：ARIMAは定常データで作業することを目指します。元のデータが定常でない場合、差分を取ります。これは以下の方程式で表現できます：

   $$\[Y_t = (1 - L)^d X_t\]$$

   ここで：
   - $\(Y_t\)$は差分系列です。
   - $\(L\)$はラグ演算子です。
   - $\(d\)$は差分の次数です。

3. **移動平均（MA）コンポーネント**：この部分は過去の誤差項の移動平均をモデル化し、以下の方程式で表現できます：

   $$\[X_t = \mu + \varepsilon_t - \theta_1 \varepsilon_{t-1} - \theta_2 \varepsilon_{t-2} - \ldots - \theta_q \varepsilon_{t-q}\]$$

   ここで：
   - $\(\mu\)$は系列の平均です。
   - $\(\theta_1, \theta_2, \ldots, \theta_q\)$は移動平均係数です。
   - $\(\varepsilon_t\)$はホワイトノイズ誤差項です。

ARIMAはこれらの要素を組み合わせて時系列データをモデル化し、予測します。

# SARIMAX（季節性自己回帰和分移動平均と外生的説明変数）

SARIMAXは季節性コンポーネントと外部説明変数（外生的説明変数）を含むARIMAモデルの拡張です。以下は詳細な説明です。

1. **季節性（S）コンポーネント**：SARIMAXは季節性パターンを考慮に入れるため、季節性の差分を導入します。これは以下の方程式で表現できます：

   $$\[Y_t = (1 - L)^d (1 - L^s) X_t\]$$

   ここで：
   - $\(s\)$は季節の周期です。
   - $\(L\)$はラグ演算子です。
   - $\(d\)$は非季節的差分の次数です。

2. **外生的説明変数（X）コンポーネント**：SARIMAXは、時系列に影響を与える可能性のある外部変数を組み込むことができます。これはデータに影響を与える他の要因がある場合に特に有用です。モデルは以下のように表現できます：

   $$\[Y_t = (1 - L)^d (1 - L^s) X_t + \beta_1 Z_{1t} + \beta_2 Z_{2t} + \ldots + \beta_k Z_{kt} + \varepsilon_t\]$$

   ここで：
   - $\(Z_{1t}, Z_{2t}, \ldots, Z_{kt}\)$は外生変数です。
   - $\(\beta_1, \beta_2, \ldots, \beta_k\)$は対応する係数です。

SARIMAXは季節性パターンと外部要因を考慮した時系列データの予測に対応した多目的なモデルです。