"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from typing import Mapping, Optional, Union, cast
from zendesk import errors, models, utils
from zendesk._hooks import HookContext
from zendesk.types import BaseModel, OptionalNullable, UNSET
from zendesk.utils import get_security_from_env


class Basics(BaseSDK):
    def open_ticket_in_agent_browser(
        self,
        *,
        agent_id: int,
        ticket_id: int,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> str:
        r"""Open Ticket in Agent's Browser

        Allows you to instruct an agent's browser to open a ticket.

        When the message is successfully delivered to an agent's browser:

        ```http
        Status: 200 OK
        ```

        When `agent_id` or `ticket_id` is invalid:

        ```http
        Status: 404 Not Found
        ```

        #### Allowed For
        * Agents

        :param agent_id: ID of an agent
        :param ticket_id: The ID of the ticket
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.OpenTicketInAgentBrowserRequest(
            agent_id=agent_id,
            ticket_id=ticket_id,
        )

        req = self._build_request(
            method="POST",
            path="/api/v2/channels/voice/agents/{agent_id}/tickets/{ticket_id}/display",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="OpenTicketInAgentBrowser",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "200", "application/json"):
            return utils.unmarshal_json(http_res.text, str)
        if utils.match_response(http_res, ["404", "4XX"], "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise errors.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def open_ticket_in_agent_browser_async(
        self,
        *,
        agent_id: int,
        ticket_id: int,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> str:
        r"""Open Ticket in Agent's Browser

        Allows you to instruct an agent's browser to open a ticket.

        When the message is successfully delivered to an agent's browser:

        ```http
        Status: 200 OK
        ```

        When `agent_id` or `ticket_id` is invalid:

        ```http
        Status: 404 Not Found
        ```

        #### Allowed For
        * Agents

        :param agent_id: ID of an agent
        :param ticket_id: The ID of the ticket
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.OpenTicketInAgentBrowserRequest(
            agent_id=agent_id,
            ticket_id=ticket_id,
        )

        req = self._build_request_async(
            method="POST",
            path="/api/v2/channels/voice/agents/{agent_id}/tickets/{ticket_id}/display",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="OpenTicketInAgentBrowser",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "200", "application/json"):
            return utils.unmarshal_json(http_res.text, str)
        if utils.match_response(http_res, ["404", "4XX"], "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise errors.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    def open_users_profile_in_agent_browser(
        self,
        *,
        agent_id: int,
        user_id: int,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> str:
        r"""Open a User's Profile in an Agent's Browser

        Allows you to instruct an agent's browser to open a user's profile.

        When the message is successfully delivered to an agent's browser:

        ```http
        Status: 200 OK
        ```

        When `agent_id` or `user_id` is invalid:

        ```http
        Status: 404 Not Found
        ```

        #### Allowed For
        * Agents

        :param agent_id: ID of an agent
        :param user_id: The id of the user
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.OpenUsersProfileInAgentBrowserRequest(
            agent_id=agent_id,
            user_id=user_id,
        )

        req = self._build_request(
            method="POST",
            path="/api/v2/channels/voice/agents/{agent_id}/users/{user_id}/display",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="OpenUsersProfileInAgentBrowser",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "200", "application/json"):
            return utils.unmarshal_json(http_res.text, str)
        if utils.match_response(http_res, ["404", "4XX"], "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise errors.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def open_users_profile_in_agent_browser_async(
        self,
        *,
        agent_id: int,
        user_id: int,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> str:
        r"""Open a User's Profile in an Agent's Browser

        Allows you to instruct an agent's browser to open a user's profile.

        When the message is successfully delivered to an agent's browser:

        ```http
        Status: 200 OK
        ```

        When `agent_id` or `user_id` is invalid:

        ```http
        Status: 404 Not Found
        ```

        #### Allowed For
        * Agents

        :param agent_id: ID of an agent
        :param user_id: The id of the user
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.OpenUsersProfileInAgentBrowserRequest(
            agent_id=agent_id,
            user_id=user_id,
        )

        req = self._build_request_async(
            method="POST",
            path="/api/v2/channels/voice/agents/{agent_id}/users/{user_id}/display",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="OpenUsersProfileInAgentBrowser",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "200", "application/json"):
            return utils.unmarshal_json(http_res.text, str)
        if utils.match_response(http_res, ["404", "4XX"], "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise errors.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    def create_ticket_or_voicemail_ticket(
        self,
        *,
        request: Optional[
            Union[
                models.TicketCreateVoicemailTicketRequest,
                models.TicketCreateVoicemailTicketRequestTypedDict,
            ]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TicketResponse:
        r"""Create Ticket or Voicemail Ticket

        #### Allowed For
        * Agents

        ### Creating tickets

        #### Introduction

        Creating tickets using Talk Partner Edition follows the same conventions as the Create Ticket endpoint. See [Create Ticket](/api-reference/ticketing/tickets/tickets/#create-ticket).

        #### Request parameters

        The POST request takes a mandatory `ticket` object that lists the values to set when the ticket is created.
        You may also include an optional `display_to_agent` value such as the ID of the agent that will see the newly created ticket.
        The `display_to_agent` is validated before creating the ticket, returning a 422 error if it is invalid.

        Tickets created using this endpoint must have a `via_id` parameter. See the following
        section for possible values.

        #### Zendesk Talk Integration Via IDs

        Tickets created using this endpoint must have one of the following `via_id` parameters:

        | ID       | Description
        | ---------| -------------
        | 44       | Voicemail
        | 45       | Phone call (inbound)
        | 46       | Phone call (outbound)

        ### Creating voicemail tickets
        #### Request parameters

        The POST request takes a mandatory `ticket` object that lists the values to set when the ticket is created.
        The ticket must have a `voice_comment` with the following values:

        | Name               | Type                  | Comment
        | ------------------ | ----------------------| -------
        | from               | string                | Incoming phone number
        | to                 | string                | Dialed phone number
        | recording_url      | string                | URL of the recording
        | started_at         | date                  | [ISO 8601](http://en.wikipedia.org/wiki/ISO_8601) timestamp of the call starting time
        | call_duration      | integer               | Duration in seconds of the call
        | answered_by_id     | integer               | The agent who answered the call
        | transcription_text | string                | Transcription of the call (optional)
        | location           | string                | Location of the caller (optional)

        :param request: The request object to send.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        if not isinstance(request, BaseModel):
            request = utils.unmarshal(
                request, Optional[models.TicketCreateVoicemailTicketRequest]
            )
        request = cast(Optional[models.TicketCreateVoicemailTicketRequest], request)

        req = self._build_request(
            method="POST",
            path="/api/v2/channels/voice/tickets",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request,
                False,
                True,
                "json",
                Optional[models.TicketCreateVoicemailTicketRequest],
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="CreateTicketOrVoicemailTicket",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "201", "application/json"):
            return utils.unmarshal_json(http_res.text, models.TicketResponse)
        if utils.match_response(http_res, ["404", "422", "4XX"], "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise errors.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def create_ticket_or_voicemail_ticket_async(
        self,
        *,
        request: Optional[
            Union[
                models.TicketCreateVoicemailTicketRequest,
                models.TicketCreateVoicemailTicketRequestTypedDict,
            ]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TicketResponse:
        r"""Create Ticket or Voicemail Ticket

        #### Allowed For
        * Agents

        ### Creating tickets

        #### Introduction

        Creating tickets using Talk Partner Edition follows the same conventions as the Create Ticket endpoint. See [Create Ticket](/api-reference/ticketing/tickets/tickets/#create-ticket).

        #### Request parameters

        The POST request takes a mandatory `ticket` object that lists the values to set when the ticket is created.
        You may also include an optional `display_to_agent` value such as the ID of the agent that will see the newly created ticket.
        The `display_to_agent` is validated before creating the ticket, returning a 422 error if it is invalid.

        Tickets created using this endpoint must have a `via_id` parameter. See the following
        section for possible values.

        #### Zendesk Talk Integration Via IDs

        Tickets created using this endpoint must have one of the following `via_id` parameters:

        | ID       | Description
        | ---------| -------------
        | 44       | Voicemail
        | 45       | Phone call (inbound)
        | 46       | Phone call (outbound)

        ### Creating voicemail tickets
        #### Request parameters

        The POST request takes a mandatory `ticket` object that lists the values to set when the ticket is created.
        The ticket must have a `voice_comment` with the following values:

        | Name               | Type                  | Comment
        | ------------------ | ----------------------| -------
        | from               | string                | Incoming phone number
        | to                 | string                | Dialed phone number
        | recording_url      | string                | URL of the recording
        | started_at         | date                  | [ISO 8601](http://en.wikipedia.org/wiki/ISO_8601) timestamp of the call starting time
        | call_duration      | integer               | Duration in seconds of the call
        | answered_by_id     | integer               | The agent who answered the call
        | transcription_text | string                | Transcription of the call (optional)
        | location           | string                | Location of the caller (optional)

        :param request: The request object to send.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        if not isinstance(request, BaseModel):
            request = utils.unmarshal(
                request, Optional[models.TicketCreateVoicemailTicketRequest]
            )
        request = cast(Optional[models.TicketCreateVoicemailTicketRequest], request)

        req = self._build_request_async(
            method="POST",
            path="/api/v2/channels/voice/tickets",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request,
                False,
                True,
                "json",
                Optional[models.TicketCreateVoicemailTicketRequest],
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="CreateTicketOrVoicemailTicket",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "201", "application/json"):
            return utils.unmarshal_json(http_res.text, models.TicketResponse)
        if utils.match_response(http_res, ["404", "422", "4XX"], "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise errors.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )
