"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from pydantic import model_serializer
from typing import Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL


class AccountSettingsBrandingObjectTypedDict(TypedDict):
    r"""Branding settings. See [Branding](#branding)"""

    favicon_url: NotRequired[Nullable[str]]
    header_color: NotRequired[str]
    header_logo_url: NotRequired[Nullable[str]]
    page_background_color: NotRequired[str]
    tab_background_color: NotRequired[str]
    text_color: NotRequired[str]


class AccountSettingsBrandingObject(BaseModel):
    r"""Branding settings. See [Branding](#branding)"""

    favicon_url: OptionalNullable[str] = UNSET

    header_color: Optional[str] = None

    header_logo_url: OptionalNullable[str] = UNSET

    page_background_color: Optional[str] = None

    tab_background_color: Optional[str] = None

    text_color: Optional[str] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "favicon_url",
            "header_color",
            "header_logo_url",
            "page_background_color",
            "tab_background_color",
            "text_color",
        ]
        nullable_fields = ["favicon_url", "header_logo_url"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
