"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from typing import Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel


class EmailSenderAuthenticationProfile(str, Enum):
    r"""The sender authentication profile in use."""

    DEFAULT = "default"
    ENHANCED = "enhanced"


class AccountSettingsEmailObjectTypedDict(TypedDict):
    r"""Email settings"""

    accept_wildcard_emails: NotRequired[bool]
    custom_dkim_domain: NotRequired[bool]
    email_sender_authentication: NotRequired[bool]
    r"""Whether incoming email is subjected to sender authentication checks (SPF, DKIM)"""
    email_sender_authentication_profile: NotRequired[EmailSenderAuthenticationProfile]
    r"""The sender authentication profile in use."""
    email_status: NotRequired[bool]
    r"""Whether email status and delivery information is shown in the Agent Workspace"""
    email_template_photos: NotRequired[bool]
    email_template_section: NotRequired[bool]
    gmail_actions: NotRequired[bool]
    modern_email_template: NotRequired[bool]
    no_mail_delimiter: NotRequired[bool]
    personalized_replies: NotRequired[bool]
    send_gmail_messages_via_gmail: NotRequired[bool]


class AccountSettingsEmailObject(BaseModel):
    r"""Email settings"""

    accept_wildcard_emails: Optional[bool] = None

    custom_dkim_domain: Optional[bool] = None

    email_sender_authentication: Optional[bool] = None
    r"""Whether incoming email is subjected to sender authentication checks (SPF, DKIM)"""

    email_sender_authentication_profile: Optional[EmailSenderAuthenticationProfile] = (
        None
    )
    r"""The sender authentication profile in use."""

    email_status: Optional[bool] = None
    r"""Whether email status and delivery information is shown in the Agent Workspace"""

    email_template_photos: Optional[bool] = None

    email_template_section: Optional[bool] = None

    gmail_actions: Optional[bool] = None

    modern_email_template: Optional[bool] = None

    no_mail_delimiter: Optional[bool] = None

    personalized_replies: Optional[bool] = None

    send_gmail_messages_via_gmail: Optional[bool] = None
