"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .activityobject import ActivityObject, ActivityObjectTypedDict
from pydantic import model_serializer
from typing import Any, Dict, List, Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL


class ActivitiesResponseTypedDict(TypedDict):
    activities: NotRequired[List[ActivityObjectTypedDict]]
    actors: NotRequired[List[Dict[str, Any]]]
    count: NotRequired[int]
    next_page: NotRequired[Nullable[str]]
    previous_page: NotRequired[Nullable[str]]
    users: NotRequired[List[Dict[str, Any]]]


class ActivitiesResponse(BaseModel):
    activities: Optional[List[ActivityObject]] = None

    actors: Optional[List[Dict[str, Any]]] = None

    count: Optional[int] = None

    next_page: OptionalNullable[str] = UNSET

    previous_page: OptionalNullable[str] = UNSET

    users: Optional[List[Dict[str, Any]]] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "activities",
            "actors",
            "count",
            "next_page",
            "previous_page",
            "users",
        ]
        nullable_fields = ["next_page", "previous_page"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
