"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from zendesk.types import BaseModel
from zendesk.utils import FieldMetadata, QueryParamMetadata


class AutocompleteOrganizationsRequestTypedDict(TypedDict):
    name: str
    r"""A substring of an organization to search for"""
    field_id: NotRequired[str]
    r"""The id of a lookup relationship field.  The type of field is determined
    by the `source` param

    """
    source: NotRequired[str]
    r"""If a `field_id` is provided, this specifies the type of the field.
    For example, if the field is on a \"zen:user\", it references a field on a user

    """


class AutocompleteOrganizationsRequest(BaseModel):
    name: Annotated[
        str, FieldMetadata(query=QueryParamMetadata(style="form", explode=True))
    ]
    r"""A substring of an organization to search for"""

    field_id: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The id of a lookup relationship field.  The type of field is determined
    by the `source` param

    """

    source: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""If a `field_id` is provided, this specifies the type of the field.
    For example, if the field is on a \"zen:user\", it references a field on a user

    """
