"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .conditionsobject import ConditionsObject, ConditionsObjectTypedDict
from datetime import datetime
from typing import Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel


class DeletionScheduleTypedDict(TypedDict):
    active: NotRequired[bool]
    r"""Whether the deletion schedule is active"""
    conditions: NotRequired[ConditionsObjectTypedDict]
    r"""An object that describes the conditions under which the automation will execute. See [Conditions reference](/documentation/ticketing/reference-guides/conditions-reference)"""
    created_at: NotRequired[datetime]
    r"""The time the deletion schedule was created"""
    default: NotRequired[bool]
    r"""Whether the deletion schedule is the default"""
    description: NotRequired[str]
    r"""The description of the deletion schedule"""
    id: NotRequired[int]
    r"""The id of the deletion schedule"""
    title: NotRequired[str]
    r"""The title of the deletion schedule"""
    updated_at: NotRequired[datetime]
    r"""The time the deletion schedule was last updated"""
    url: NotRequired[str]
    r"""Url for obtaining the deletion schedule JSON"""


class DeletionSchedule(BaseModel):
    active: Optional[bool] = None
    r"""Whether the deletion schedule is active"""

    conditions: Optional[ConditionsObject] = None
    r"""An object that describes the conditions under which the automation will execute. See [Conditions reference](/documentation/ticketing/reference-guides/conditions-reference)"""

    created_at: Optional[datetime] = None
    r"""The time the deletion schedule was created"""

    default: Optional[bool] = None
    r"""Whether the deletion schedule is the default"""

    description: Optional[str] = None
    r"""The description of the deletion schedule"""

    id: Optional[int] = None
    r"""The id of the deletion schedule"""

    title: Optional[str] = None
    r"""The title of the deletion schedule"""

    updated_at: Optional[datetime] = None
    r"""The time the deletion schedule was last updated"""

    url: Optional[str] = None
    r"""Url for obtaining the deletion schedule JSON"""
