"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .dynamiccontentvariantobject import (
    DynamicContentVariantObject,
    DynamicContentVariantObjectTypedDict,
)
from datetime import datetime
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel


class DynamicContentObjectTypedDict(TypedDict):
    default_locale_id: int
    r"""The default locale for the item. Must be one of the [locales the account has active](/api-reference/ticketing/account-configuration/locales/#list-locales)."""
    name: str
    r"""The unique name of the item"""
    variants: List[DynamicContentVariantObjectTypedDict]
    r"""All variants within this item. See [Dynamic Content Item Variants](/api-reference/ticketing/ticket-management/dynamic_content_item_variants/)"""
    created_at: NotRequired[datetime]
    r"""When this record was created"""
    id: NotRequired[int]
    r"""Automatically assigned when creating items"""
    outdated: NotRequired[bool]
    r"""Indicates the item has outdated variants within it"""
    placeholder: NotRequired[str]
    r"""Automatically generated placeholder for the item, derived from name"""
    updated_at: NotRequired[datetime]
    r"""When this record was last updated"""
    url: NotRequired[str]
    r"""The API url of this item"""


class DynamicContentObject(BaseModel):
    default_locale_id: int
    r"""The default locale for the item. Must be one of the [locales the account has active](/api-reference/ticketing/account-configuration/locales/#list-locales)."""

    name: str
    r"""The unique name of the item"""

    variants: List[DynamicContentVariantObject]
    r"""All variants within this item. See [Dynamic Content Item Variants](/api-reference/ticketing/ticket-management/dynamic_content_item_variants/)"""

    created_at: Optional[datetime] = None
    r"""When this record was created"""

    id: Optional[int] = None
    r"""Automatically assigned when creating items"""

    outdated: Optional[bool] = None
    r"""Indicates the item has outdated variants within it"""

    placeholder: Optional[str] = None
    r"""Automatically generated placeholder for the item, derived from name"""

    updated_at: Optional[datetime] = None
    r"""When this record was last updated"""

    url: Optional[str] = None
    r"""The API url of this item"""
