"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from zendesk.types import BaseModel
from zendesk.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata


class ExecuteViewRequestTypedDict(TypedDict):
    view_id: int
    r"""The ID of the view"""
    sort_by: NotRequired[str]
    r"""The ticket field used for sorting. This will either be a title or a custom field id."""
    sort_order: NotRequired[str]
    r"""The direction the tickets are sorted. May be one of 'asc' or 'desc'"""


class ExecuteViewRequest(BaseModel):
    view_id: Annotated[
        int, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""The ID of the view"""

    sort_by: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The ticket field used for sorting. This will either be a title or a custom field id."""

    sort_order: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The direction the tickets are sorted. May be one of 'asc' or 'desc'"""
