"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from typing_extensions import Annotated, TypedDict
from zendesk.types import BaseModel
from zendesk.utils import FieldMetadata, PathParamMetadata


class GetSourcesByTargetRequestTypedDict(TypedDict):
    target_type: str
    r"""The type of object the relationship field is targeting.
    The options are \"zen:user\", \"zen:ticket\", \"zen:organization\", and \"zen:custom_object:CUSTOM_OBJECT_KEY\" 

    """
    target_id: int
    r"""The id of the object the relationship field is targeting

    """
    field_id: int
    r"""The id of the lookup relationship field

    """
    source_type: str
    r"""The type of object the relationship field belongs to (example. ticket field belongs to a ticket object).
    The options are \"zen:user\", \"zen:ticket\", \"zen:organization\", and \"zen:custom_object:CUSTOM_OBJECT_KEY\" 

    """


class GetSourcesByTargetRequest(BaseModel):
    target_type: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""The type of object the relationship field is targeting.
    The options are \"zen:user\", \"zen:ticket\", \"zen:organization\", and \"zen:custom_object:CUSTOM_OBJECT_KEY\" 

    """

    target_id: Annotated[
        int, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""The id of the object the relationship field is targeting

    """

    field_id: Annotated[
        int, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""The id of the lookup relationship field

    """

    source_type: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""The type of object the relationship field belongs to (example. ticket field belongs to a ticket object).
    The options are \"zen:user\", \"zen:ticket\", \"zen:organization\", and \"zen:custom_object:CUSTOM_OBJECT_KEY\" 

    """
