"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .ticketauditsresponsenonecursor import (
    TicketAuditsResponseNoneCursor,
    TicketAuditsResponseNoneCursorTypedDict,
)
import pydantic
from typing import Callable, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from zendesk.types import BaseModel
from zendesk.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata


class ListAuditsForTicketRequestTypedDict(TypedDict):
    ticket_id: int
    r"""The ID of the ticket"""
    page_size: NotRequired[int]
    r"""Number of records per page (required for cursor pagination)"""
    page_after: NotRequired[str]
    r"""Cursor for pagination (opaque string)"""


class ListAuditsForTicketRequest(BaseModel):
    ticket_id: Annotated[
        int, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""The ID of the ticket"""

    page_size: Annotated[
        Optional[int],
        pydantic.Field(alias="page[size]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 100
    r"""Number of records per page (required for cursor pagination)"""

    page_after: Annotated[
        Optional[str],
        pydantic.Field(alias="page[after]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Cursor for pagination (opaque string)"""


class ListAuditsForTicketResponseTypedDict(TypedDict):
    result: TicketAuditsResponseNoneCursorTypedDict


class ListAuditsForTicketResponse(BaseModel):
    next: Callable[[], Optional[ListAuditsForTicketResponse]]

    result: TicketAuditsResponseNoneCursor
