"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .brandsresponse import BrandsResponse, BrandsResponseTypedDict
import pydantic
from typing import Callable, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from zendesk.types import BaseModel
from zendesk.utils import FieldMetadata, QueryParamMetadata


class ListBrandsRequestTypedDict(TypedDict):
    page_size: NotRequired[int]
    r"""Number of records per page (required for cursor pagination)"""
    page_after: NotRequired[str]
    r"""Cursor for pagination (opaque string)"""


class ListBrandsRequest(BaseModel):
    page_size: Annotated[
        Optional[int],
        pydantic.Field(alias="page[size]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 100
    r"""Number of records per page (required for cursor pagination)"""

    page_after: Annotated[
        Optional[str],
        pydantic.Field(alias="page[after]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Cursor for pagination (opaque string)"""


class ListBrandsResponseTypedDict(TypedDict):
    result: BrandsResponseTypedDict


class ListBrandsResponse(BaseModel):
    next: Callable[[], Optional[ListBrandsResponse]]

    result: BrandsResponse
