"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from zendesk.types import BaseModel
from zendesk.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata


class ListTicketsFromViewRequestTypedDict(TypedDict):
    view_id: int
    r"""The ID of the view"""
    sort_by: NotRequired[str]
    r"""Sort or group the tickets by a column in the [View columns](#view-columns) table. The `subject` and `submitter` columns are not supported"""
    sort_order: NotRequired[str]
    r"""One of \"asc\" or \"desc\". Defaults to \"asc\" for alphabetical and position sort, \"desc\" for all others"""


class ListTicketsFromViewRequest(BaseModel):
    view_id: Annotated[
        int, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""The ID of the view"""

    sort_by: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Sort or group the tickets by a column in the [View columns](#view-columns) table. The `subject` and `submitter` columns are not supported"""

    sort_order: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""One of \"asc\" or \"desc\". Defaults to \"asc\" for alphabetical and position sort, \"desc\" for all others"""
