"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .ticketsresponse import TicketsResponse, TicketsResponseTypedDict
from enum import Enum
import pydantic
from typing import Callable, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from zendesk.types import BaseModel
from zendesk.utils import FieldMetadata, QueryParamMetadata


class ListTicketsSort(str, Enum):
    r"""Sort tickets by field (for cursor pagination use \"field\" for ascending or \"-field\" for descending)"""

    UPDATED_AT = "updated_at"
    ID = "id"
    STATUS = "status"
    MINUS_UPDATED_AT = "-updated_at"
    MINUS_ID = "-id"
    MINUS_STATUS = "-status"


class ListTicketsRequestTypedDict(TypedDict):
    external_id: NotRequired[str]
    r"""Lists tickets by external id. External ids don't have to be unique for each ticket. As a result, the request may return multiple tickets with the same external id."""
    page_size: NotRequired[int]
    r"""Number of records per page (required for cursor pagination)"""
    page_after: NotRequired[str]
    r"""Cursor for pagination (opaque string)"""
    sort: NotRequired[ListTicketsSort]
    r"""Sort tickets by field (for cursor pagination use \"field\" for ascending or \"-field\" for descending)"""


class ListTicketsRequest(BaseModel):
    external_id: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Lists tickets by external id. External ids don't have to be unique for each ticket. As a result, the request may return multiple tickets with the same external id."""

    page_size: Annotated[
        Optional[int],
        pydantic.Field(alias="page[size]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 100
    r"""Number of records per page (required for cursor pagination)"""

    page_after: Annotated[
        Optional[str],
        pydantic.Field(alias="page[after]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Cursor for pagination (opaque string)"""

    sort: Annotated[
        Optional[ListTicketsSort],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = ListTicketsSort.ID
    r"""Sort tickets by field (for cursor pagination use \"field\" for ascending or \"-field\" for descending)"""


class ListTicketsResponseTypedDict(TypedDict):
    result: TicketsResponseTypedDict


class ListTicketsResponse(BaseModel):
    next: Callable[[], Optional[ListTicketsResponse]]

    result: TicketsResponse
