"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from zendesk.types import BaseModel
from zendesk.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata


class ListUserIdentitiesType(str, Enum):
    r"""Filters results by one or more identity types using the format `?type[]={type}&type[]={type}`"""

    EMAIL = "email"
    FACEBOOK = "facebook"
    PHONE_NUMBER = "phone_number"
    SDK = "sdk"
    TWITTER = "twitter"
    MESSAGING = "messaging"
    MICROSOFT = "microsoft"


class ListUserIdentitiesRequestTypedDict(TypedDict):
    user_id: int
    r"""The id of the user"""
    type: NotRequired[ListUserIdentitiesType]
    r"""Filters results by one or more identity types using the format `?type[]={type}&type[]={type}`"""


class ListUserIdentitiesRequest(BaseModel):
    user_id: Annotated[
        int, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""The id of the user"""

    type: Annotated[
        Optional[ListUserIdentitiesType],
        pydantic.Field(alias="type[]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filters results by one or more identity types using the format `?type[]={type}&type[]={type}`"""
