"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .userrolefilter import UserRoleFilter
from .usersresponse import UsersResponse, UsersResponseTypedDict
import pydantic
from typing import Callable, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from zendesk.types import BaseModel
from zendesk.utils import FieldMetadata, QueryParamMetadata


class ListUsersRequestTypedDict(TypedDict):
    role_query_parameter: NotRequired[UserRoleFilter]
    r"""Filters the results by role. Possible values are \"end-user\", \"agent\", or \"admin\" 

    """
    role_query_parameter1: NotRequired[str]
    r"""Filters the results by more than one role using the format `role[]={role}&role[]={role}`

    """
    permission_set: NotRequired[int]
    r"""For custom roles which is available on the Enterprise plan and above. You can only filter by one role ID per request"""
    external_id: NotRequired[str]
    r"""List users by external id. External id has to be unique for each user under the same account."""
    page_size: NotRequired[int]
    r"""Number of records per page (required for cursor pagination)"""
    page_after: NotRequired[str]
    r"""Cursor for pagination (opaque string)"""


class ListUsersRequest(BaseModel):
    role_query_parameter: Annotated[
        Optional[UserRoleFilter],
        pydantic.Field(alias="role"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filters the results by role. Possible values are \"end-user\", \"agent\", or \"admin\" 

    """

    role_query_parameter1: Annotated[
        Optional[str],
        pydantic.Field(alias="role[]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filters the results by more than one role using the format `role[]={role}&role[]={role}`

    """

    permission_set: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""For custom roles which is available on the Enterprise plan and above. You can only filter by one role ID per request"""

    external_id: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""List users by external id. External id has to be unique for each user under the same account."""

    page_size: Annotated[
        Optional[int],
        pydantic.Field(alias="page[size]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 100
    r"""Number of records per page (required for cursor pagination)"""

    page_after: Annotated[
        Optional[str],
        pydantic.Field(alias="page[after]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Cursor for pagination (opaque string)"""


class ListUsersResponseTypedDict(TypedDict):
    result: UsersResponseTypedDict


class ListUsersResponse(BaseModel):
    next: Callable[[], Optional[ListUsersResponse]]

    result: UsersResponse
