"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from enum import Enum
from typing import Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel


class TicketFieldCustomStatusObjectStatusCategory(str, Enum):
    r"""The status category the custom ticket status belongs to"""

    NEW = "new"
    OPEN = "open"
    PENDING = "pending"
    HOLD = "hold"
    SOLVED = "solved"


class TicketFieldCustomStatusObjectTypedDict(TypedDict):
    active: NotRequired[bool]
    r"""If true, if the custom status is set to active. If false, the custom status is set to inactive"""
    agent_label: NotRequired[str]
    r"""The label displayed to agents"""
    created_at: NotRequired[datetime]
    r"""The date and time at which the custom ticket status was created"""
    default: NotRequired[bool]
    r"""If true, the custom status is set to default. If false, the custom status is set to non-default"""
    description: NotRequired[str]
    r"""The description of when the user should select this custom ticket status"""
    end_user_description: NotRequired[str]
    r"""The description displayed to end users"""
    end_user_label: NotRequired[str]
    r"""The label displayed to end users"""
    id: NotRequired[int]
    r"""Automatically assigned when the custom ticket status is created"""
    status_category: NotRequired[TicketFieldCustomStatusObjectStatusCategory]
    r"""The status category the custom ticket status belongs to"""
    updated_at: NotRequired[datetime]
    r"""The date and time at which the custom ticket status was last updated"""


class TicketFieldCustomStatusObject(BaseModel):
    active: Optional[bool] = None
    r"""If true, if the custom status is set to active. If false, the custom status is set to inactive"""

    agent_label: Optional[str] = None
    r"""The label displayed to agents"""

    created_at: Optional[datetime] = None
    r"""The date and time at which the custom ticket status was created"""

    default: Optional[bool] = None
    r"""If true, the custom status is set to default. If false, the custom status is set to non-default"""

    description: Optional[str] = None
    r"""The description of when the user should select this custom ticket status"""

    end_user_description: Optional[str] = None
    r"""The description displayed to end users"""

    end_user_label: Optional[str] = None
    r"""The label displayed to end users"""

    id: Optional[int] = None
    r"""Automatically assigned when the custom ticket status is created"""

    status_category: Optional[TicketFieldCustomStatusObjectStatusCategory] = None
    r"""The status category the custom ticket status belongs to"""

    updated_at: Optional[datetime] = None
    r"""The date and time at which the custom ticket status was last updated"""
