"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .customfieldoptionobject import (
    CustomFieldOptionObject,
    CustomFieldOptionObjectTypedDict,
)
from .systemfieldoptionobject import (
    SystemFieldOptionObject,
    SystemFieldOptionObjectTypedDict,
)
from .ticketfieldcustomstatusobject import (
    TicketFieldCustomStatusObject,
    TicketFieldCustomStatusObjectTypedDict,
)
from datetime import datetime
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL


class TicketFieldObjectRelationshipFilterTypedDict(TypedDict):
    r"""A filter definition that allows your autocomplete to filter down results"""


class TicketFieldObjectRelationshipFilter(BaseModel):
    r"""A filter definition that allows your autocomplete to filter down results"""


class TicketFieldObjectTypedDict(TypedDict):
    title: str
    r"""The title of the ticket field"""
    type: str
    r"""System or custom field type. Editable for custom field types and only on creation. See [Create Ticket Field](#create-ticket-field)"""
    active: NotRequired[bool]
    r"""Whether this field is available"""
    agent_can_edit: NotRequired[bool]
    r"""Whether this field is editable by agents"""
    agent_description: NotRequired[str]
    r"""A description of the ticket field that only agents can see"""
    collapsed_for_agents: NotRequired[bool]
    r"""If true, the field is shown to agents by default. If false, the field is hidden alongside infrequently used fields. Classic interface only"""
    created_at: NotRequired[datetime]
    r"""The time the custom ticket field was created"""
    creator_app_name: NotRequired[str]
    r"""Name of the app that created the ticket field, or a null value if no app created the ticket field"""
    creator_user_id: NotRequired[int]
    r"""The id of the user that created the ticket field, or a value of \"-1\" if an app created the ticket field"""
    custom_field_options: NotRequired[List[CustomFieldOptionObjectTypedDict]]
    r"""Required and presented for a custom ticket field of type \"multiselect\" or \"tagger\" """
    custom_statuses: NotRequired[List[TicketFieldCustomStatusObjectTypedDict]]
    r"""List of customized ticket statuses. Only presented for a system ticket field of type \"custom_status\" """
    description: NotRequired[str]
    r"""Describes the purpose of the ticket field to users"""
    editable_in_portal: NotRequired[bool]
    r"""Whether this field is editable by end users in Help Center"""
    id: NotRequired[int]
    r"""Automatically assigned when created"""
    position: NotRequired[int]
    r"""The relative position of the ticket field on a ticket. Note that for accounts with ticket forms, positions are controlled by the different forms"""
    raw_description: NotRequired[str]
    r"""The dynamic content placeholder if present, or the `description` value if not. See [Dynamic Content](/api-reference/ticketing/ticket-management/dynamic_content/)"""
    raw_title: NotRequired[str]
    r"""The dynamic content placeholder if present, or the `title` value if not. See [Dynamic Content](/api-reference/ticketing/ticket-management/dynamic_content/)"""
    raw_title_in_portal: NotRequired[str]
    r"""The dynamic content placeholder if present, or the \"title_in_portal\" value if not. See [Dynamic Content](/api-reference/ticketing/ticket-management/dynamic_content/)"""
    regexp_for_validation: NotRequired[Nullable[str]]
    r"""For \"regexp\" fields only. The validation pattern for a field value to be deemed valid"""
    relationship_filter: NotRequired[TicketFieldObjectRelationshipFilterTypedDict]
    r"""A filter definition that allows your autocomplete to filter down results"""
    relationship_target_type: NotRequired[str]
    r"""A representation of what type of object the field references. Options are \"zen:user\", \"zen:organization\", \"zen:ticket\", or \"zen:custom_object:{key}\" where key is a custom object key. For example \"zen:custom_object:apartment\"."""
    removable: NotRequired[bool]
    r"""If false, this field is a system field that must be present on all tickets"""
    required: NotRequired[bool]
    r"""If true, agents must enter a value in the field to change the ticket status to solved"""
    required_in_portal: NotRequired[bool]
    r"""If true, end users must enter a value in the field to create the request"""
    sub_type_id: NotRequired[int]
    r"""For system ticket fields of type \"priority\" and \"status\". Defaults to 0. A \"priority\" sub type of 1 removes the \"Low\" and \"Urgent\" options. A \"status\" sub type of 1 adds the \"On-Hold\" option"""
    system_field_options: NotRequired[List[SystemFieldOptionObjectTypedDict]]
    r"""Presented for a system ticket field of type \"tickettype\", \"priority\" or \"status\" """
    tag: NotRequired[Nullable[str]]
    r"""For \"checkbox\" fields only. A tag added to tickets when the checkbox field is selected"""
    title_in_portal: NotRequired[str]
    r"""The title of the ticket field for end users in Help Center"""
    updated_at: NotRequired[datetime]
    r"""The time the custom ticket field was last updated"""
    url: NotRequired[str]
    r"""The URL for this resource"""
    visible_in_portal: NotRequired[bool]
    r"""Whether this field is visible to end users in Help Center"""


class TicketFieldObject(BaseModel):
    title: str
    r"""The title of the ticket field"""

    type: str
    r"""System or custom field type. Editable for custom field types and only on creation. See [Create Ticket Field](#create-ticket-field)"""

    active: Optional[bool] = None
    r"""Whether this field is available"""

    agent_can_edit: Optional[bool] = None
    r"""Whether this field is editable by agents"""

    agent_description: Optional[str] = None
    r"""A description of the ticket field that only agents can see"""

    collapsed_for_agents: Optional[bool] = None
    r"""If true, the field is shown to agents by default. If false, the field is hidden alongside infrequently used fields. Classic interface only"""

    created_at: Optional[datetime] = None
    r"""The time the custom ticket field was created"""

    creator_app_name: Optional[str] = None
    r"""Name of the app that created the ticket field, or a null value if no app created the ticket field"""

    creator_user_id: Optional[int] = None
    r"""The id of the user that created the ticket field, or a value of \"-1\" if an app created the ticket field"""

    custom_field_options: Optional[List[CustomFieldOptionObject]] = None
    r"""Required and presented for a custom ticket field of type \"multiselect\" or \"tagger\" """

    custom_statuses: Optional[List[TicketFieldCustomStatusObject]] = None
    r"""List of customized ticket statuses. Only presented for a system ticket field of type \"custom_status\" """

    description: Optional[str] = None
    r"""Describes the purpose of the ticket field to users"""

    editable_in_portal: Optional[bool] = None
    r"""Whether this field is editable by end users in Help Center"""

    id: Optional[int] = None
    r"""Automatically assigned when created"""

    position: Optional[int] = None
    r"""The relative position of the ticket field on a ticket. Note that for accounts with ticket forms, positions are controlled by the different forms"""

    raw_description: Optional[str] = None
    r"""The dynamic content placeholder if present, or the `description` value if not. See [Dynamic Content](/api-reference/ticketing/ticket-management/dynamic_content/)"""

    raw_title: Optional[str] = None
    r"""The dynamic content placeholder if present, or the `title` value if not. See [Dynamic Content](/api-reference/ticketing/ticket-management/dynamic_content/)"""

    raw_title_in_portal: Optional[str] = None
    r"""The dynamic content placeholder if present, or the \"title_in_portal\" value if not. See [Dynamic Content](/api-reference/ticketing/ticket-management/dynamic_content/)"""

    regexp_for_validation: OptionalNullable[str] = UNSET
    r"""For \"regexp\" fields only. The validation pattern for a field value to be deemed valid"""

    relationship_filter: Optional[TicketFieldObjectRelationshipFilter] = None
    r"""A filter definition that allows your autocomplete to filter down results"""

    relationship_target_type: Optional[str] = None
    r"""A representation of what type of object the field references. Options are \"zen:user\", \"zen:organization\", \"zen:ticket\", or \"zen:custom_object:{key}\" where key is a custom object key. For example \"zen:custom_object:apartment\"."""

    removable: Optional[bool] = None
    r"""If false, this field is a system field that must be present on all tickets"""

    required: Optional[bool] = None
    r"""If true, agents must enter a value in the field to change the ticket status to solved"""

    required_in_portal: Optional[bool] = None
    r"""If true, end users must enter a value in the field to create the request"""

    sub_type_id: Optional[int] = None
    r"""For system ticket fields of type \"priority\" and \"status\". Defaults to 0. A \"priority\" sub type of 1 removes the \"Low\" and \"Urgent\" options. A \"status\" sub type of 1 adds the \"On-Hold\" option"""

    system_field_options: Optional[List[SystemFieldOptionObject]] = None
    r"""Presented for a system ticket field of type \"tickettype\", \"priority\" or \"status\" """

    tag: OptionalNullable[str] = UNSET
    r"""For \"checkbox\" fields only. A tag added to tickets when the checkbox field is selected"""

    title_in_portal: Optional[str] = None
    r"""The title of the ticket field for end users in Help Center"""

    updated_at: Optional[datetime] = None
    r"""The time the custom ticket field was last updated"""

    url: Optional[str] = None
    r"""The URL for this resource"""

    visible_in_portal: Optional[bool] = None
    r"""Whether this field is visible to end users in Help Center"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "active",
            "agent_can_edit",
            "agent_description",
            "collapsed_for_agents",
            "created_at",
            "creator_app_name",
            "creator_user_id",
            "custom_field_options",
            "custom_statuses",
            "description",
            "editable_in_portal",
            "id",
            "position",
            "raw_description",
            "raw_title",
            "raw_title_in_portal",
            "regexp_for_validation",
            "relationship_filter",
            "relationship_target_type",
            "removable",
            "required",
            "required_in_portal",
            "sub_type_id",
            "system_field_options",
            "tag",
            "title_in_portal",
            "updated_at",
            "url",
            "visible_in_portal",
        ]
        nullable_fields = ["regexp_for_validation", "tag"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
